import { MesQbFinishErrorModel, MesQbFinishErrorPageParams, MesQbFinishErrorPageResult } from './model/MesFinishErrorModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesfinisherror/page',
  List = '/mes/mesfinisherror/list',
  Info = '/mes/mesfinisherror/info',
  MesQbFinishError = '/mes/mesfinisherror',
  
  
}

/**
 * @description: 查询MesQbFinishError分页列表
 */
export async function getMesQbFinishErrorPage(params: MesQbFinishErrorPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbFinishErrorPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbFinishError信息
 */
export async function getMesQbFinishError(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbFinishErrorModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbFinishError
 */
export async function addMesQbFinishError(mesQbFinishError: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbFinishError,
      params: mesQbFinishError,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbFinishError
 */
export async function updateMesQbFinishError(mesQbFinishError: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbFinishError,
      params: mesQbFinishError,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbFinishError（批量删除）
 */
export async function deleteMesQbFinishError(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbFinishError,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}