import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProductionTask分页参数 模型
 */
export interface MesProductionTaskPageParams extends BasicPageParams {
  rwbh: string;

  jhbh: string;

  hjzt: string;
}

/**
 * @description: MesProductionTask分页返回值模型
 */
export interface MesProductionTaskPageModel {
  id: string;

  jhbh: string;

  rwbh: string;

  cpid: string;

  rch: string;

  zch: string;

  jhksrq: string;

  jhjsrq: string;
}

/**
 * @description: MesProductionTask表类型
 */
export interface MesProductionTaskModel {
  id: string;

  deleteMark: string;

  rwbh: string;

  jhbh: string;

  rch: string;

  zch: string;

  hjzt: string;

  cpid: string;

  cplx: string;

  kh: string;

  gg: string;

  sl: string;

  zl: string;

  jz: string;

  zxbz: string;

  jhksrq: string;

  jhjsrq: string;

  bom: string;

  gylx: string;

  scrq: string;

  sccj: string;

  sccx: string;

  jsyq: string;

  sfnbdd: string;

  zt: string;

  bz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesProductionGongdanList?: MesProductionGongdanModel;

  mesWarehouseMaterialList?: MesWarehouseMaterialModel[];
}

/**
 * @description: MesProductionGongdan表类型
 */
export interface MesProductionGongdanModel {
  id: string;

  roductionTaskId: string;

  deleteMark: string;

  rwbh: string;

  jhbh: string;

  zzl: string;

  rch: string;

  zch: string;

  hjzt: string;

  cpid: string;

  cplx: string;

  gxId: string;

  gxbh: string;

  gxmc: string;

  kh: string;

  gg: string;

  sl: string;

  zl: string;

  zxbz: string;

  jhksrq: string;

  jhjsrq: string;

  scrq: string;

  sccj: string;

  sccx: string;

  jsyq: string;

  sfnbdd: string;

  zt: string;

  bz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesWarehouseMaterial表类型
 */
export interface MesWarehouseMaterialModel {
  id: string;

  wlId: string;

  roductionTaskId: string;

  deleteMark: string;

  bz: string;

  zt: string;

  wlbh: string;

  wlmc: string;

  wlgg: string;

  wlxh: string;

  xjbom: string;

  blsl: string;

  kcl: string;

  khbz: string;

  nkbz: string;

  sftl: string;

  bldh: string;

  lldh: string;

  llr: string;

  llbm: string;

  llsl: string;

  shren: string;

  fllldh: string;

  fllrq: string;

  fllr: string;

  fllbm: string;

  fllsl: string;

  flgg: string;

  flbz: string;

  p1: string;

  p2: string;

  p3: string;

  p4: string;

  p5: string;

  p6: string;

  p7: string;

  p8: string;

  p9: string;

  p10: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesProductionTask分页返回值结构
 */
export type MesProductionTaskPageResult = BasicFetchResult<MesProductionTaskPageModel>;
