import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface PurchaseOrderPageListParams {
  theme?: string; //订单名称
}

export interface OrderDetailParamsModel {
  code: string; //物料编码
  name: string; //物料名称
  model: string; //规格型号
  unitName: string; //单位
  price?: number; //单价
  count?: number; //数量
  discount?: number; //折扣
  taxRate?: string; //税率
  taxBreak?: string; //税费
  afterTaxAmount?: string; //税后金额
  deliveryDate?: string; //交付日期
}

export interface PurchaseOrderAddParamsModel {
  purchaseNumber: string; //采购单号
  isSysNumBoolean?: boolean; //是否使用系统编号
  applyId?: string; //关联申请单
  isRelationApplyBoolean?: boolean; //是否不关联申请单
  theme: string; //订单主题
  purchaseDate: string; //采购日期
  supplierId?: string; //供应商名称
  supplierPerson?: string; //联系人
  supplierWay?: string; //联系方式
  purchaseDeptId?: string; //采购部门
  purchasePersonId?: string; //采购人员
  purchasePhone?: string; //联系电话
  relatedProject?: string; //关联项目
  payType?: string; //结算方式
  payAddress?: string; //交付地址
  remark?: string; //备注
  filePath?: string; //附件地址
  countSum: string | number; //总数量
  amountSum: string | number; //总金额
  addCaseErpPurchaseDetailDtoList: OrderDetailParamsModel[];
}

export interface PurchaseOrderUpdateParamsModel {
  id: string; //详情id
  purchaseNumber: string; //采购单号
  isSysNumBoolean?: boolean; //是否使用系统编号
  applyId?: string; //关联申请单
  isRelationApplyBoolean?: boolean; //是否不关联申请单
  theme: string; //订单主题
  purchaseDate: string; //采购日期
  supplierId?: string; //供应商名称
  supplierPerson?: string; //联系人
  supplierWay?: string; //联系方式
  purchaseDeptId?: string; //采购部门
  purchasePersonId?: string; //采购人员
  purchasePhone?: string; //联系电话
  relatedProject?: string; //关联项目
  payType?: string; //结算方式
  payAddress?: string; //交付地址
  remark?: string; //备注
  filePath?: string; //附件地址
  countSum: string | number; //总数量
  amountSum: string | number; //总金额
  addCaseErpPurchaseDetailDtoList: OrderDetailParamsModel[];
}

export interface PurchaseOrderrUpdateParamsModel {
  id: string; //详情id
  purchaseNumber: string; //采购单号
  isSysNumBoolean?: boolean; //是否使用系统编号
  applyId?: string; //关联申请单
  isRelationApplyBoolean?: boolean; //是否不关联申请单
  theme: string; //订单主题
  purchaseDate: string; //采购日期
  supplierId?: string; //供应商名称
  supplierPerson?: string; //联系人
  supplierWay?: string; //联系方式
  purchaseDeptId?: string; //采购部门
  purchasePersonId?: string; //采购人员
  purchasePhone?: string; //联系电话
  relatedProject?: string; //关联项目
  payType?: string; //结算方式
  payAddress?: string; //交付地址
  remark?: string; //备注
  filePath?: string; //附件地址
  countSum: string | number; //总数量
  amountSum: string | number; //总金额
  addCaseErpPurchaseDetailDtoList: OrderDetailParamsModel[];
}

export interface PurchaseOrderCheckInfoModel {
  id: string; //详情id
  theme: string; //订单主题
  createUserName: string; //创建人
  createDate: string; //创建时间
  modifyUserName: string; //最后修改人
  modifyDate: string; //修改时间
  purchaseNumber: string; //采购单号
  purchaseDate: string; //采购日期
  supplierName: string; //供应商名称
  supplierPerson: string; //联系人
  supplierWay: string; //联系方式
  purchaseDeptName: string; //采购部门
  purchasePersonName: string; //采购人员
  purchasePhone: string; //联系电话
  relatedProjectName: string; //关联项目
  payTypeName: string; //结算方式
  payAddress: string; //交货地址
  remark: string; //备注
  countSum: number; //总量
  amountSum: number; //总金额
  filePath: string; //附件
  inStoreState: number; //入库
  ticketState: number; //到票
  payState: number; //收款
  caseErpPurchaseDetailList: OrderDetailParamsModel[];
  inStoreLogVoList: InstoreInfoModel[];
  ticketLogVoList: TicketInfoModel[];
  payLogVoList: PayInfoModel[];
  logList: LogInfoModel[];
}

export interface InstoreInfoModel {
  code: string; //入库单号
  theme: string; //入库订单主题
  date: string; //入库日期
  name: string; //供应商名称
  count: number; //入库总量
  person: string; //入库人员
  store: string; //入库仓库
}

export interface TicketInfoModel {
  code: string; //到票编号
  theme: string; //到票主题
  date: string; //到票日期
  name: string; //开票方
  ticketNum: string; //发票号码
  ticketAmout: string; //到票金额
}

export interface PayInfoModel {
  code: string; //付款编号
  theme: string; //付款主题
  date: string; //付款日期
  amount: string; //付款总额
  payer: string; //收款方
  account: string; //银行账号
}

export interface LogInfoModel {
  operateUserAccount: string; //操作人
  createDate: string; //操作时间
  executeResultJson: string; //操作类型
}

export interface PurchaseOrderListModel {
  id: string; //详情id
  purchaseNumber: string; //采购编码
  theme: string; //采购订单名称
  supplierName: string; //供应商
  purchaseDate: string; //采购日期
  purchaseDeptName: string; //采购部门
  purchasePersonName: string; //采购人员
  purchaseDetail: string; //采购物品
  amountSum: number; //总金额
  alreadyAmount: number; //已收金额
  alreadyTicket: number; //已到票金额
  inStoreState: number; //入库
  ticketState: number; //到票
  payState: number; //付款
}

export type PurchaseOrderPageListSearchModel = BasicPageParams & PurchaseOrderPageListParams;
export type PurchaseOrderPageListResultModel = BasicFetchResult<PurchaseOrderListModel>;
