import 'virtual:svg-icons-register';
import SvgIcon from "./icons/index.vue";
import DataVVue3 from '@kjgl77/datav-vue3'
import JsonViewer from 'vue-json-viewer'
import 'vue-json-viewer/style.css'
import AvueData from '@/page/view.vue'
import draggable from '@avue/avue-draggable'
import '@avue/avue-draggable/dist/style.css'
import highlight from '@/page/components/highlight.vue'
import {
  loadScript
} from '@/utils/utils'
import {
  website
} from '@/config.js'
import '@/styles/common.scss'
import hljs from 'highlight.js' //导入代码高亮文件
import 'highlight.js/styles/atom-one-dark.css'
import mqtt from 'mqtt';

import components from '@/components/';
import echartComponents from '@/echart/'

import error from './error';
import debug from './debug'
import keys from './lisence'

export function registerInstall (Vue, { app, config = {}, axios }) {
  config = Object.assign(website, config)
  let list = { ...echartComponents, ...components }
  Object.keys(list).map(ele => {
    let component = list[ele];
    app.component(component.name, component);
  });
  delete app._context.components['avue-draggable'];
  app.use(draggable, {
    keys
  })
  app.use(DataVVue3)
  const $loadingParams = {};
  $loadingParams['element-loading-text'] = "加载中..."
  $loadingParams['element-loading-background'] = "rgba(32,32,35, 0.8)"
  app.config.globalProperties.$loadingParams = $loadingParams
  app.config.globalProperties.$website = Object.assign(window.$website || website, config);
  app.component('avue-data', AvueData)
  document.title = website.title
  window.mqtt = mqtt;
  window.axios = axios;
  window.$loadScript = loadScript;
}

function registerLibs (config, axios, router, app) {
  registerInstall(null, { app, config, axios })
  app.directive('highlight', function (el) {
    let highlight = el.querySelectorAll('pre code');
    highlight.forEach((block) => {
      hljs.highlightBlock(block)
    })
  });
  debug()
  app.use(router);
  app.use(error);
  app.use(JsonViewer)
  app.component('avue-highlight', highlight)
  app.component("svg-icon", SvgIcon)
}


function registerRouters (config, router) {
  let mainPath = config.routers.mainPath
  if (!router) return
  const routers = [{
    path: mainPath,
    component: () => import('@/page/index.vue'),
    children: [{
      path: '',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/index.vue')
    },
    {
      path: 'category',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/category.vue'),
    },
    {
      path: 'nav',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/nav.vue'),
    }, {
      path: 'db',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/db.vue'),
    },
    {
      path: 'map',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/map.vue')
    }, {
      path: 'document',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/document.vue')
    },
    {
      path: 'glob',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/glob.vue')
    }, {
      path: 'components',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/components.vue')

    }, {
      path: 'file',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/file.vue')
    }, {
      path: 'fill',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/fill.vue')
    }, {
      path: 'task',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/task.vue')
    }, {
      path: 'record',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/record.vue')
    }, {
      path: 'chatgpt',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/chatgpt.vue')
    }, {
      path: 'fun',
      component: () => import( /* webpackChunkName: "list" */ '@/page/list/fun.vue')
    }, {
      path: 'market',
      component: () => import(/* webpackChunkName: "list" */ '@/page/list/market.vue')
    }]
  }, {
    path: mainPath + 'build',
    name: 'build',
    component: () => import( /* webpackChunkName: "build" */ '@/page/build.vue')
  }, {
    path: mainPath + 'build/:id',
    name: 'build',
    component: () => import( /* webpackChunkName: "build" */ '@/page/build.vue')
  }, {
    path: mainPath + 'view/:id',
    name: 'view',
    component: () => import( /* webpackChunkName: "build" */ '@/page/view.vue')
  }]
  if (router.addRoutes) {
    router.addRoutes(routers)
  } else {
    routers.forEach((route) => {
      router.addRoute(route)
    })
  }
}
export default function ({
  app,
  config = {},
  router,
  axios
}) {
  config = Object.assign(website, config)
  registerRouters(config, router)
  registerLibs(config, axios, router, app)
}