import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'companyId',
    label: '公司',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/bmxx/getCompanyList',
        method: 'GET',
        apiId: 'copy1765431632890d13798',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from res_company";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'lotRuleId',
    label: '批次号',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'code',
    title: '编号',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'companyId',
    title: '公司',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'lotRuleId',
    title: '批次号',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '1a2696deffa44bc08208686bb5e77715',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: '536715321b4c49df8b63b2fcb7cc14ab',
              field: 'code',
              label: '编号',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '自动生成',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'GYBH',
                required: false,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '62dc90bd2b2548f39626c59222f2c208',
              field: 'companyId',
              label: '公司',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getCompanyList',
                  method: 'GET',
                  apiId: 'copy1765431632890d13798',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from res_company";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '8d9ef135306242729fb4673b9e2dd918',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '2a666ef333114556a7e018a75573fd92',
              field: 'lotRuleId',
              label: '批次号',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '自动生成',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'GYPC',
                required: false,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '6636f959cd3a4c239aeb3ab43505a27b',
              field: 'active',
              label: '有效的',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                span: 7,
                defaultValue: 1,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#433653',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'b7ea8bb6e83b42129ec31ca2cb3716e4',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '08fea1146775468ba1b3ba1193710e09',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入备注备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'e64fff4326284f16aa6d86acb8678b89',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '4646ad154e7d404e9dae94f1022a5788',
              field: '',
              label: '',
              type: 'tab',
              colProps: { span: 24 },
              component: 'Tab',
              children: [
                {
                  span: 24,
                  name: '工艺明细',
                  prefix: '',
                  suffix: '',
                  activeColor: '#1c8dff',
                  folderId: '',
                  imageUrl: '',
                  conFolderId: '',
                  conImageUrl: '',
                  list: [
                    {
                      key: 'e75eeef314c4485c922588bb979d0b04',
                      label: '',
                      field: 'rokeRoutingProcessList',
                      type: 'form',
                      component: 'SubForm',
                      required: true,
                      colProps: { span: 24 },
                      componentProps: {
                        mainKey: 'rokeRoutingProcessList',
                        columns: [
                          {
                            key: '9e9467d976174786a67851ccb34bb8f7',
                            title: '名称',
                            dataIndex: 'processId',
                            componentType: 'MultiplePopup',
                            componentProps: {
                              popupType: 'associate',
                              width: '100%',
                              span: '',
                              placeholder: '请选择工序',
                              showLabel: true,
                              disabled: false,
                              datasourceType: 'api',
                              labelField: 'label',
                              valueField: 'value',
                              pageSize: 10,
                              assoTitle: '选择工序',
                              apiConfig: {
                                path: '/jcxx/gxlb',
                                method: 'GET',
                                apiId: '8a735bb14d5f4a709efb65b34691acd3',
                                apiParams: [
                                  { key: '1', title: 'Query Params', tableInfo: [] },
                                  { key: '2', title: 'Header', tableInfo: [] },
                                  { key: '3', title: 'Body' },
                                ],
                                script:
                                  'var sql="select * from roke_process where delete_mark = 0";\r\nreturn db.select(sql);',
                                outputParams: [
                                  {
                                    name: 'code',
                                    tableTitle: '编码',
                                    bindField: 'code',
                                    show: true,
                                    width: 150,
                                    component: '8f0c524797e64b40bc4124837d406cdb',
                                    bindTable: 'roke_routing_process',
                                  },
                                  { name: 'name', tableTitle: '名称', show: true, width: 150 },
                                  {
                                    name: 'collection_scheme_id',
                                    tableTitle: '',
                                    bindField: 'collectionSchemeId',
                                    show: false,
                                    width: 150,
                                    component: 'bfdf4979bec74654ae607c3339e56ef2',
                                    bindTable: 'roke_routing_process',
                                  },
                                  {
                                    name: 'category_id',
                                    tableTitle: '',
                                    bindField: 'categoryId',
                                    show: false,
                                    width: 150,
                                    component: 'a56d6b8d54aa4d7c8246feb647f8da8b',
                                    bindTable: 'roke_routing_process',
                                  },
                                  {
                                    name: 'rated_working_hours',
                                    tableTitle: '',
                                    bindField: 'ratedWorkingHours',
                                    show: false,
                                    width: 150,
                                    component: 'd7f88b9a824042b8b717ba4ffc0aa729',
                                    bindTable: 'roke_routing_process',
                                  },
                                ],
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: '8f0c524797e64b40bc4124837d406cdb',
                            title: '编码',
                            dataIndex: 'code',
                            componentType: 'Input',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              placeholder: '请输入编码',
                              prefix: '',
                              suffix: '',
                              addonBefore: '',
                              addonAfter: '',
                              disabled: true,
                              allowClear: false,
                              showLabel: true,
                              required: false,
                              rules: [],
                              events: {},
                              listStyle: '',
                              isSave: false,
                              isShow: true,
                              scan: false,
                              bordered: true,
                              isShowAi: false,
                              tooltipConfig: { visible: false, title: '提示文本' },
                            },
                          },
                          {
                            key: 'a56d6b8d54aa4d7c8246feb647f8da8b',
                            title: '工序类别',
                            dataIndex: 'categoryId',
                            componentType: 'XjrSelect',
                            componentProps: {
                              width: '100%',
                              span: '',
                              placeholder: '请选择下拉选择',
                              showLabel: true,
                              showSearch: false,
                              isMultiple: false,
                              clearable: false,
                              disabled: true,
                              staticOptions: [
                                { key: 1, label: 'Option 1', value: 'Option 1' },
                                { key: 2, label: 'Option 2', value: 'Option 2' },
                                { key: 3, label: 'Option 3', value: 'Option 3' },
                              ],
                              datasourceType: 'dic',
                              params: { itemId: '2005547790246666242' },
                              labelField: 'name',
                              valueField: 'value',
                              apiConfig: {
                                path: '/jcxx/getCollectionSchemeList',
                                method: 'GET',
                                apiId: 'copy1767064303024d70507',
                                apiParams: [
                                  { key: '1', title: 'Query Params', tableInfo: [] },
                                  { key: '2', title: 'Header', tableInfo: [] },
                                  { key: '3', title: 'Body' },
                                ],
                                script:
                                  'var sql="select id as value,name as label from mes_collection_scheme where delete_mark = 0";\r\nreturn db.select(sql);',
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                              itemId: '2005547790246666242',
                              listStyle: "return 'border: 0'",
                            },
                          },
                          {
                            key: 'bfdf4979bec74654ae607c3339e56ef2',
                            title: '采集方案',
                            dataIndex: 'collectionSchemeId',
                            componentType: 'XjrSelect',
                            componentProps: {
                              width: '100%',
                              span: '',
                              placeholder: '请选择下拉选择',
                              showLabel: true,
                              showSearch: false,
                              isMultiple: false,
                              clearable: false,
                              disabled: true,
                              staticOptions: [
                                { key: 1, label: 'Option 1', value: 'Option 1' },
                                { key: 2, label: 'Option 2', value: 'Option 2' },
                                { key: 3, label: 'Option 3', value: 'Option 3' },
                              ],
                              defaultSelect: '',
                              datasourceType: 'api',
                              labelField: 'label',
                              valueField: 'value',
                              apiConfig: {
                                path: '/jcxx/getCollectionSchemeList',
                                method: 'GET',
                                apiId: 'copy1767064303024d70507',
                                apiParams: [
                                  { key: '1', title: 'Query Params', tableInfo: [] },
                                  { key: '2', title: 'Header', tableInfo: [] },
                                  { key: '3', title: 'Body' },
                                ],
                                script:
                                  'var sql="select id as value,name as label from mes_collection_scheme where delete_mark = 0";\r\nreturn db.select(sql);',
                              },
                              dicOptions: [],
                              required: false,
                              rules: [],
                              events: {},
                              isShow: true,
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'border: 0'",
                            },
                          },
                          {
                            key: 'd7f88b9a824042b8b717ba4ffc0aa729',
                            title: '额定工时',
                            dataIndex: 'ratedWorkingHours',
                            componentType: 'InputNumber',
                            defaultValue: '',
                            componentProps: {
                              width: '100%',
                              span: '',
                              defaultValue: '',
                              step: 0.01,
                              disabled: true,
                              showLabel: true,
                              controls: true,
                              required: false,
                              subTotal: false,
                              isShow: true,
                              rules: [],
                              events: {},
                              tooltipConfig: { visible: false, title: '提示文本' },
                              listStyle: "return 'width:100%'",
                            },
                          },
                          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                        ],
                        span: 7,
                        preloadType: 'api',
                        apiConfig: {},
                        itemId: '',
                        dicOptions: [],
                        useSelectButton: false,
                        buttonName: '选择数据',
                        showLabel: true,
                        showComponentBorder: true,
                        showBorder: false,
                        bordercolor: '#f0f0f0',
                        bordershowtype: [true, true, true, true],
                        borderwidth: 1,
                        showIndex: false,
                        isShow: true,
                        multipleHeads: [],
                        buttonList: [],
                        topButtonList: [],
                        isExport: false,
                        isImport: false,
                        isDeleteSelected: false,
                        isListView: false,
                        viewList: [],
                        isShowAdd: true,
                        isShowDelete: true,
                        hasCheckedCol: false,
                        events: {},
                        showPagenation: true,
                      },
                    },
                  ],
                },
              ],
              componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
  },
];
