
import { MesCollectionItemPageModel, MesCollectionItemPageParams, MesCollectionItemPageResult } from './model/CjxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/cjx/page',
  List = '/jcsj/cjx/list',
  Info = '/jcsj/cjx/info',
  MesCollectionItem = '/jcsj/cjx',
  
  
  
}

/**
 * @description: 查询MesCollectionItem分页列表
 */
export async function getMesCollectionItemPage(params: MesCollectionItemPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCollectionItemPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesCollectionItem信息
 */
export async function getMesCollectionItem(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCollectionItemPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesCollectionItem
 */
export async function addMesCollectionItem(mesCollectionItem: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesCollectionItem,
      params: mesCollectionItem,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesCollectionItem
 */
export async function updateMesCollectionItem(mesCollectionItem: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesCollectionItem,
      params: mesCollectionItem,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesCollectionItem（批量删除）
 */
export async function deleteMesCollectionItem(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesCollectionItem,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




