import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQbSemifinReport分页参数 模型
 */
export interface MesQbSemifinReportPageParams extends BasicPageParams {
  reportNo: string;

  reportName: string;

  checkDate: string;

  checkUser: string;

  samplingStandard: string;

  samplingNum: string;

  chekcType: string;

  checkProduct: string;

  checkStandard: string;

  checkMethod: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;

  errorState: string;
}

/**
 * @description: MesQbSemifinReport分页返回值模型
 */
export interface MesQbSemifinReportPageModel {
  id: string;

  reportNo: string;

  reportName: string;

  checkDate: string;

  checkUser: string;

  samplingStandard: string;

  samplingNum: string;

  chekcType: string;

  checkProduct: string;

  checkStandard: string;

  checkMethod: string;

  createDate: string;

  judgeResult: string;

  errorState: string;

  remark: string;
}

/**
 * @description: MesQbSemifinReport表类型
 */
export interface MesQbSemifinReportModel {
  id: number;

  isSysNum: string;

  reportNo: string;

  reportName: string;

  checkUser: string;

  checkDate: string;

  samplingStandard: string;

  samplingNum: string;

  chekcType: string;

  checkProduct: string;

  checkStandard: string;

  checkMethod: string;

  checkreportNo: string;

  judgeResult: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesQbSemifinDetailList?: MesQbSemifinDetailModel;
}

/**
 * @description: MesQbSemifinDetail表类型
 */
export interface MesQbSemifinDetailModel {
  id: number;

  reportId: number;

  reportNo: string;

  reportName: string;

  workNo: string;

  saleId: string;

  saleNo: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  workshop: string;

  referenceValue: string;

  upTolerance: string;

  downTolerance: string;

  measuredValue: string;

  errorNum: string;

  errorMethod: string;

  imgFile: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQbSemifinReport分页返回值结构
 */
export type MesQbSemifinReportPageResult = BasicFetchResult<MesQbSemifinReportPageModel>;
