
import { MesBaseBomPageModel, MesBaseBomPageParams, MesBaseBomPageResult } from './model/WlqdModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/wlqd/page',
  List = '/jcsj/wlqd/list',
  Info = '/jcsj/wlqd/info',
  MesBaseBom = '/jcsj/wlqd',
  
  
  Export = '/jcsj/wlqd/export',
  
}

/**
 * @description: 查询MesBaseBom分页列表
 */
export async function getMesBaseBomPage(params: MesBaseBomPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseBomPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseBom信息
 */
export async function getMesBaseBom(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseBomPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseBom
 */
export async function addMesBaseBom(mesBaseBom: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseBom,
      params: mesBaseBom,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseBom
 */
export async function updateMesBaseBom(mesBaseBom: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseBom,
      params: mesBaseBom,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseBom（批量删除）
 */
export async function deleteMesBaseBom(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseBom,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesBaseBom
 */
export async function exportMesBaseBom(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
  

