import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import { BomInfoResultModel, BomAddParamsModel, BomTreeModel, BomUpdateParamsModel } from './model';

enum Api {
  Tree = '/caseErpBom/caseErpBom/tree',
  Bom = '/caseErpBom/caseErpBom',
  Info = '/caseErpBom/caseErpBom/info',
  Verification = '/caseErpBom/caseErpBom/verification',
  Export = '/caseErpBom/caseErpBom/export',
  Import = '/caseErpBom/caseErpBom/import',
}

/**
 * @description: 查询BOM树
 */
export async function getBomTree(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<BomTreeModel>(
    {
      url: Api.Tree,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增BOM物料
 */
export async function addBomMaterial(type: BomAddParamsModel, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.Bom,
      params: type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改BOM物料
 */
export async function updateBomMaterial(
  type: BomUpdateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.Bom,
      params: type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除BOM物料
 */
export async function deleteBomMaterial(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Bom,
      data: id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 系统验证
 */
export async function getVerification(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<number>(
    {
      url: Api.Verification,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 根据id查询物料信息(当前以及子级信息)
 */
export async function getBomInfo(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<BomInfoResultModel>(
    {
      url: Api.Info,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'POST',
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 下载模板
 */
export async function downloadTemplate(mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导入
 */
export async function importInfo(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.post(
    {
      url: Api.Import,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
