import { reactive } from 'vue';
import { setExclusiveApprovalProcess } from '@/common/api/system/dictionary/index.js';

// 流程审批独占模式
export function useExclusiveApprovalProcess() {
  const exclusiveApprovalProcessData: {
    taskId: string;
  } = reactive({
    taskId: '',
  });
  function setData(taskId) {
    uni.setStorageSync('exclusiveApprovalProcessTaskId', taskId);
  }
  function resetData() {
    setData('');
  }
  // 开启
  async function handleOpenExclusiveApprovalProcess(taskId) {
    setData(taskId);
  }
  // 关闭
  async function handleCLoseExclusiveApprovalProcess() {
    try {
      const val = uni.getStorageSync('exclusiveApprovalProcessTaskId');
      if (val) {
        resetData();
        await setExclusiveApprovalProcess(val);
      }
    } catch (error) {}
  }

  return {
    exclusiveApprovalProcessData,
    handleOpenExclusiveApprovalProcess,
    handleCLoseExclusiveApprovalProcess,
  };
}
