import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface InspectPageListParams {
  typeId?: string; //设备类型id
  name?: string; //设备名称
  state?: string; //状态 1-已完成 2-未维修
}

export interface InspectAddParamsModel {
  typeId: string; //设备类型id
  number?: string; //设备编号
  deviceId: string; //设备名称
  model: string; //规格型号
  checkedUserIds: string; //巡检人
  date: string; //巡检时间
  natureId: string; //检查性质
  result?: string; //检查结果
  filePath?: string; //上传附件
  state?: string; //状态
}

export interface InspectUpdateParamsModel {
  id: string; //详情id
  typeId: string; //设备类型id
  number?: string; //设备编号
  deviceId: string; //设备名称
  model: string; //规格型号
  checkedUserIds: string; //巡检人
  date: string; //巡检时间
  nature: string; //检查性质
  result?: string; //检查结果
  filePath?: string; //上传附件
  state?: string; //状态
}

export interface InspectInfoModel {
  typeId: string; //设备类型id
  number?: string; //设备编号
  deviceId: string; //设备id
  name: string; //设备名称
  model: string; //规格型号
  checkedUserIds: string; //巡检人Id
  checkedUserNames: string; //巡检人
  date: string; //巡检时间
  natureId: string; //检查性质id
  natureName: string; //检查性质
  result?: string; //检查结果
  filePath?: string; //上传附件
  state?: string; //状态
  address: string; //设备位置
}

export interface InspectListModel {
  id: string; //详情id
  number: string; //设备编号
  deviceId: string; //设备名称
  typeName: string; //设备类型
  model: string; //规格型号
  supplierName: number; //供应商
  address: string; //设备位置
  principalNames: string; //负责人
  buyDate: string; //购买日期
  maintianDate: string; //维保日期0
  scrapDate: string; //报废日期
  state: number; //状态 0-异常 1-正常
}

export type InspectPageListSearchModel = BasicPageParams & InspectPageListParams;
export type InspectPageListResultModel = BasicFetchResult<InspectListModel>;
