
import { 
  getMesProductionPlanPage,
  deleteMesProductionPlan 
} from '@/common/api/scgl/scjh/index.js';
import {
  componentType,
  datasourceTypeEnum
} from '@/components/simple-form/types/form.js'


export const listProps = {
  rowKey:'id',
  //列表请求接口
  api: getMesProductionPlanPage,
  // 请求之前处理参数 (params) => {}
  beforeFetch: (params) => {
    for(let key in params){
			if(key.includes(',')){
				delete params[key]
			}
		}
    params.PK='id'
		params.FormId='2004396568728281088'
    return params
  },
  // 自定义处理接口返回参数
  afterFetch: (data) => {
    return data
  },
  //数据源  静态
  datasource: [],
  workflowConfig:{
    Pk:'id',
    Formid:'2004396568728281088'
  },
  //列配置
  columnConfigs: [
    {
        title: '计划编号',
        mainField:false,
			  showLabel:true,
        componentType:'Input',
        field: 'jhbh',
      },{
        title: '订单编号',
        mainField:false,
			  showLabel:true,
        componentType:'Input',
        field: 'ddbh',
      },{
        title: '客户',
        mainField:false,
			  showLabel:true,
        componentType:'Input',
        field: 'kh',
      },{
        title: '计划交付日期',
        mainField:false,
			  showLabel:true,
        componentType:'DateTime',
        field: 'jhjhrq',
      },{
        title: '状态',
        mainField:false,
			  showLabel:true,
        componentType:'Select',
        field: 'zt',
      }
  ],
  //是否启用搜索
  isSearch: true,
  //是否分页
  isPage: true,
  pageSize: 10,
  //分类筛选配置
  categoryConfigs:"",
  //搜索配置
  searchConfigs: [{
      key: 'bb401260571f476c9816266b858aa2fa',
      name: '计划编号',
      label: '计划编号',
      field: 'jhbh',
      component: componentType.input, //组件类型
      componentProps: { 
        placeholder: '请输入计划编号',
      }
    },
{
      key: '0cad80076f6347b5966ef3d246d23165',
      name: '订单编号',
      label: '订单编号',
      field: 'ddbh',
      component: componentType.input, //组件类型
      componentProps: { 
        placeholder: '请输入订单编号',
      }
    },
{
        key: 'f7ae7fe08ec74cf6b91cd3cd35cfeaaf',
      name: '状态',
      label: '状态',
        field: 'zt',
        component: componentType.select, //组件类型
        componentProps: {"placeholder":"请选择下拉选择","isShow":false,"itemId":"2004464883576217601","map":{"text":"name","value":"value"},"multiple":false,"isSearch":false},
      },],
  //表单页面地址
  formUrl: '/pages/scgl/scjh/container',
  //列表页面地址
  listUrl: '/pages/scgl/scjh/list',
  //按钮配置
  otherButtons:[
        {
          text: '查看',
          isUse:true,
          code:'scjh:view',
        },
        {
          text: '新增',
          isUse:true,
          code:'scjh:add',
        },
        {
          text: '发起审批',
          isUse:false,
          code:'scjh:startwork',
        },
        {
          text: '下发任务',
          isUse:true,
          code:'scjh:xiafa',
        }],
  buttonConfigs: [{
        code: 'scjh:edit',
        icon: 'ant-design:edit-square',
        color:'#5E95FF',
        text: '编辑',
        action: (record) =>{
          uni.navigateTo({
            url: listProps.formUrl + '?type=edit&id=' + record[listProps.rowKey],
          });
        }
      },{
        code: 'scjh:delete',
        icon: 'ant-design:delete-outlined',
        color:'#EF6969',
        text: '删除',
        action: async (record, { reload }) => {
          await deleteMesProductionPlan ([record[listProps.rowKey]]);
          reload()
          //请求删除接口
          uni.showToast({
            title: "删除成功"
          })
        } 
      },{
      code: 'more',
      icon: 'ant-design:lipsis-outlined',
      color: '#5E95FF',
      text: '更多',
      buttons: [{"buttonId":"2004471125057142784","name":"下发任务","code":"xiafa","icon":"ant-design:export-outlined","isDefault":false,"isUse":true,"setting":[],"showType":"top","buttonType":"primary","isEnableLock":null,"schemaInitConfig":null,"apiConfig":null,"modal":null}],
      action: async (record, { showMoreButton }) => {
        showMoreButton(record[listProps.rowKey])
      },
    }],
  formEventConfig:{"0":[],"1":[],"2":[],"3":[],"4":[]}
}


export const formProps =  {"validateTrigger":"submit","labelPosition":"left","labelWidth":75,"labelAlign":"right","errShowType":"undertext","border":false,"schemas":[{"key":"bb401260571f476c9816266b858aa2fa","field":"jhbh","label":"计划编号","component":"Input","componentProps":{"placeholder":"请输入计划编号","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":true,"rules":[{"required":true,"errorMessage":"计划编号项必填"}],"name":"计划编号","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"cde76649b62b4db4a820c7fccfe2810c","field":"khxmh","label":"客户项目号","component":"Input","componentProps":{"placeholder":"请输入客户项目号","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"客户项目号","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"253e91345aeb4346b0081560c11c9420","field":"sfnbdd","label":"是否内部订单","component":"Radio","defaultValue":"option 1","componentProps":{"isShow":true,"localdata":[{"key":2,"label":"是","value":"1"},{"key":3,"label":"否","value":"2"}],"map":{"text":"label","value":"value"},"mode":"default"},"required":true,"rules":[{"required":true,"errorMessage":"是否内部订单项必填"}],"name":"是否内部订单","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"0cad80076f6347b5966ef3d246d23165","field":"ddbh","label":"订单编号","component":"Input","componentProps":{"placeholder":"请输入订单编号","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"订单编号","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"7db6a62a09e347149a3110719726e010","field":"jhjhrq","label":"计划交付日期","component":"DateTime","componentProps":{"clearIcon":true,"placeholder":"请选择计划交付日期","type":"datetime","formatType":"datetime","isShow":true},"required":false,"rules":[],"name":"计划交付日期","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"c40beca261124a17b8ea5258ae8b1b82","field":"jsyq","label":"技术要求","component":"FileUpload","defaultValue":"","componentProps":{"showType":"text","fileExtname":[],"limit":5,"multiple":false,"maxSize":"","sourceType":["album","camera"],"isShow":true},"required":false,"rules":[],"name":"技术要求","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"105fe8a606b74e0ca90ea9ff1d20b648","field":"kh","label":"客户","component":"Input","componentProps":{"placeholder":"请输入客户","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"客户","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"6833bea0c42c432b83e6946695f2d723","field":"ssgs","label":"所属公司","component":"Select","componentProps":{"placeholder":"请选择下拉选择","isShow":true,"apiConfig":{"method":"GET","path":"/bmxx/getCompanyList","requestParamsConfigs":[],"requestHeaderConfigs":[],"requestBodyConfigs":[]},"map":{"text":"label","value":"value"},"multiple":false,"isSearch":false},"required":false,"rules":[],"name":"所属公司","ifShow":true,"dynamicDisabled":false,"events":{}},{"field":"mesProductionPlanProductList","key":"24ea4c6631d047a1a8e7c3fe86ab080c","name":"表格组件","component":"SubForm","columns":[{"key":"416cd1b15c314d0dafaf6fc91e3f4653","field":"cpid","label":"产品选择","component":"AssociatePopup","componentProps":{"placeholder":"请选择产品选择","isShow":true,"apiConfig":{"method":"GET","path":"/scgl/scjh/getAllProduct","requestParamsConfigs":[],"requestHeaderConfigs":[],"requestBodyConfigs":[]},"map":{"text":"label","value":"value"},"associateOptions":[{"name":"cpmc","tableTitle":"产品名称","bindField":"","show":true,"width":150},{"name":"cpbh","tableTitle":"物料编号","bindField":"cpbh","show":true,"width":150,"component":"cd0038f42bc64c189b3821f0e2061321","bindTable":"mes_production_plan_product"},{"name":"nbdm","tableTitle":"内部代码","bindField":"nbdm","show":true,"width":150,"component":"6ce71ecb0b6e4d14ae65be4029b179fd","bindTable":"mes_production_plan_product"},{"name":"xh","tableTitle":"型号","bindField":"xh","show":true,"width":150,"component":"0c075736898c431ea3f5bca58ec65af6","bindTable":"mes_production_plan_product"},{"name":"gg","tableTitle":"规格","bindField":"gg","show":true,"width":150,"component":"2f56d9297a9c49d59d3b43f62e2946f2","bindTable":"mes_production_plan_product"},{"name":"hjzt","tableTitle":"合金状态","bindField":"hjzt","show":true,"width":150,"component":"697829b6aed54b8cbaa853c62619831a","bindTable":"mes_production_plan_product"}]},"required":false,"rules":[],"name":"产品选择","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"cd0038f42bc64c189b3821f0e2061321","field":"cpbh","label":"物料编号","component":"Input","componentProps":{"placeholder":"请输入物料编号","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"物料编号","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"6ce71ecb0b6e4d14ae65be4029b179fd","field":"nbdm","label":"内部代码","component":"Input","componentProps":{"placeholder":"请输入内部代码","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"内部代码","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"0c075736898c431ea3f5bca58ec65af6","field":"xh","label":"型号","component":"Input","componentProps":{"placeholder":"请输入型号","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"型号","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"697829b6aed54b8cbaa853c62619831a","field":"hjzt","label":"合金状态","component":"Input","componentProps":{"placeholder":"请输入合金状态","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"合金状态","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"2f56d9297a9c49d59d3b43f62e2946f2","field":"gg","label":"规格（尺寸）","component":"Input","componentProps":{"placeholder":"请输入规格（尺寸）","prefixIcon":"","suffixIcon":"","addonBefore":"","addonAfter":"","clearable":false,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"规格（尺寸）","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"6a93c6d77ce1428c9fbba62a02afd6d0","field":"sl","label":"数量","component":"InputNumber","defaultValue":0,"componentProps":{"min":0,"step":1,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"数量","ifShow":true,"dynamicDisabled":false,"events":{}},{"key":"3b80cb19086e49e1a746cf9ace3f938e","field":"zl","label":"质量/KG","component":"InputNumber","defaultValue":0,"componentProps":{"min":0,"step":0.1,"maxlength":-1,"isShow":true},"required":false,"rules":[],"name":"质量/KG","ifShow":true,"dynamicDisabled":false,"events":{}}],"componentProps":{"isShow":true},"useSelectButton":false,"buttonName":"选择数据","preloadType":"api"},{"key":"f7ae7fe08ec74cf6b91cd3cd35cfeaaf","field":"zt","label":"状态","component":"Select","defaultValue":"1","componentProps":{"placeholder":"请选择下拉选择","isShow":false,"itemId":"2004464883576217601","map":{"text":"name","value":"value"},"multiple":false,"isSearch":false},"required":false,"rules":[],"name":"状态","ifShow":false,"dynamicDisabled":false,"events":{}}],"rules":[]};

