import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface languagePageListParams {
  keyword?: string; //关键字
}
/**
 * 翻译json格式
 */
export interface LanguageJsonResultModel {
  [key: string]: LanguageMapModel; //关键字
}

/**
 * 翻译映射
 */
export interface LanguageMapModel {
  [key: string]: string; //关键字
}

/**
 * @description: Request list interface parameters
 */
export type LgPageListSearchModel = BasicPageParams & languagePageListParams;

export interface AuthPageListModel {
  code: string; //编码
  name: string; //名称
}

/**
 * @description: Request list return value
 */
export type AuthPageListResultModel = BasicFetchResult<AuthPageListModel>;

export interface AuthModel {
  data: authConfig;
}
interface authConfig {
  title: string;
  remark?: string;
  code: string;
}
