import { MesQpProcessPatrolerrorModel, MesQpProcessPatrolerrorPageParams, MesQpProcessPatrolerrorPageResult } from './model/MesProcessPlErrorModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesprocessplerror/page',
  List = '/mes/mesprocessplerror/list',
  Info = '/mes/mesprocessplerror/info',
  MesQpProcessPatrolerror = '/mes/mesprocessplerror',
  
  
}

/**
 * @description: 查询MesQpProcessPatrolerror分页列表
 */
export async function getMesQpProcessPatrolerrorPage(params: MesQpProcessPatrolerrorPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQpProcessPatrolerrorPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQpProcessPatrolerror信息
 */
export async function getMesQpProcessPatrolerror(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQpProcessPatrolerrorModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQpProcessPatrolerror
 */
export async function addMesQpProcessPatrolerror(mesQpProcessPatrolerror: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQpProcessPatrolerror,
      params: mesQpProcessPatrolerror,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQpProcessPatrolerror
 */
export async function updateMesQpProcessPatrolerror(mesQpProcessPatrolerror: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQpProcessPatrolerror,
      params: mesQpProcessPatrolerror,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQpProcessPatrolerror（批量删除）
 */
export async function deleteMesQpProcessPatrolerror(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQpProcessPatrolerror,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}