import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesCollectionScheme分页参数 模型
 */
export interface MesCollectionSchemePageParams extends BasicPageParams {
  code: string;

  name: string;

  contentType: string;

  note: string;
}

/**
 * @description: MesCollectionScheme分页返回值模型
 */
export interface MesCollectionSchemePageModel {
  id: string;

  code: string;

  name: string;

  contentType: string;
}

/**
 * @description: MesCollectionScheme表类型
 */
export interface MesCollectionSchemeModel {
  id: string;

  code: string;

  name: string;

  contentType: string;

  companyId: string;

  note: string;

  deleteMark: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  mesCollectionSchemeItemList?: MesCollectionSchemeItemModel;
}

/**
 * @description: MesCollectionSchemeItem表类型
 */
export interface MesCollectionSchemeItemModel {
  id: string;

  stemId: string;

  schemeId: string;

  code: string;

  name: string;

  required: string;

  categoryId: string;

  contentType: string;

  dataType: string;

  dictId: string;

  relatedModelId: string;

  relatedModelName: string;

  relatedModelDomain: string;

  standardValue: string;

  upperValue: string;

  lowerValue: string;

  note: string;

  companyId: string;

  qualityCategoryId: string;

  analysisMethod: string;

  qualityMethodId: string;

  destructive: string;

  keyItem: string;

  deleteMark: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: MesCollectionScheme分页返回值结构
 */
export type MesCollectionSchemePageResult = BasicFetchResult<MesCollectionSchemePageModel>;
