import config from '@/common/config/index.js'
import { useChatStore } from "@/common/store/im/chatStore.js";
import { useFriendStore } from '@/common/store/im/friendStore.js';
import { useGroupStore } from '@/common/store/im/groupStore.js';
import { useIMUserStore } from '@/common/store/im/imUserStore.js';
import * as wsApi from '@/common/config/wssocket';

// 请求队列
let requestList = [];
// 是否正在刷新中
let isRefreshToken = false;

const request = (options) => {
	const header = options.header || {};
	const loginInfo = uni.getStorageSync("loginInfo");
	if (loginInfo) {
		header.accessToken = loginInfo.accessToken;
	}
	return new Promise(function (resolve, reject) {
		uni.request({
			url: config.IM_BASE_URL + options.url,
			method: options.method || 'GET',
			header: header,
			data: options.data || {},
			async success(res) {
				if (res.data.code == 200) {
					return resolve(res.data.data)
				} else if (res.data.code == 400) {
					exit();
				} else if (res.data.code == 401) {
					console.log("token失效，尝试重新获取")
					if (isRefreshToken) {
						// 正在刷新token,把其他请求存起来
						requestList.push(() => {
							resolve(request(options))
						})
						return;
					}
					isRefreshToken = true;
					// 发送请求, 进行刷新token操作, 获取新的token
					const res = await reqRefreshToken(loginInfo);
					if (!res || res.data.code != 200) {
						requestList = [];
						isRefreshToken = false;
						console.log("刷新token失败")
						exit();
						return;
					}
					uni.setStorageSync("loginInfo", res.data.data);
					requestList.forEach(cb => cb());
					requestList = [];
					isRefreshToken = false;
					// 重新发送刚才的请求
					return resolve(request(options))

				} else {
					uni.showToast({
						icon: "none",
						title: res.data.message,
						duration: 1500
					})
					return reject(res.data)
				}
			},
			fail(error) {
				uni.showToast({
					title: "网络似乎有点不给力，请稍后重试",
					duration: 1500
				})
				return reject(error)
			}
		});
	});
}


const reqRefreshToken = (loginInfo) => {
	return new Promise(function (resolve, reject) {
		uni.request({
			method: 'PUT',
			url: config.IM_BASE_URL + '/refreshToken',
			header: {
				refreshToken: loginInfo.refreshToken
			},
			success: (res) => {
				resolve(res);
			},
			fail: (res) => {
				reject(res);
			}
		});
	});
}

const exit = () => {
	wsApi.close();
	uni.removeStorageSync("loginInfo");
	uni.reLaunch({
		url: "/pages/login/login",
	});
	useFriendStore().clear();
	useGroupStore().clear();
	useChatStore().clear();
	useIMUserStore().clear();
};

export default request;