import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'categoryId',
    label: '工序类别',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/gxlb/getTypeList',
        method: 'GET',
        apiId: 'c1695a5b0fbe48e1817740557a3c5d4e',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from roke_process_category";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'processType',
    label: '分类',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2001198355203006466' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'collectionItem',
    label: '采集项',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2001194974510096385' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'note',
    label: '备注',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'categoryId',
    title: '工序类别',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'processType',
    title: '分类',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'collectionSchemeId',
    title: '采集方案',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [{ key: 1, label: '无', value: '无' }];

      return staticOptions.filter((x) => x.value == record.collectionSchemeId)[0]?.label;
    },

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'note',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'left',
  layout: 'horizontal',
  size: 'small',
  schemas: [
    {
      key: '04fbf175bf2a4661a06e44126776617b',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '60af544637c442bcb20cdbf2cd71a2c2',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'aa72d19636d540078e40a0dae8b90e3c',
              field: 'defaultReporter',
              label: '默认报工人员',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getEmployeeList',
                  method: 'GET',
                  apiId: 'copy1765432049337d61208',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'aabb539eede446daa35c754416cc50ae',
              field: 'prepareWorkHours',
              label: '是否委外',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#303030',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '9b11a988a0cf4332876bf2c525fab878',
              field: 'isPress',
              label: '是否扣除工装生命周期',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 11,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#303030',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '16def0c2f9d8422da5d403e11b8c38e0',
              field: 'categoryId',
              label: '工序类别',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/gxlb/getTypeList',
                  method: 'GET',
                  apiId: 'c1695a5b0fbe48e1817740557a3c5d4e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_process_category";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'b228a5dee6274901924bd0b9eb675ec7',
              field: 'processType',
              label: '分类',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                params: { itemId: '2001198355203006466' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {
                  change:
                    "\nlet value = formModel.process_type;\n\nvar fieldConfigs = [\n    {field: 'b02f8a3e28b24689bb5a311945bb2519,roke_process_childList'},\n  //{field: 'name'},\n  \n];\nfieldConfigs.forEach(function(config) {\n    var isHidden = false;\n\n    if (value == 2) {\n        isHidden = true;\n    }\n    formActionType.updateSchema({\n        field: config.field,\n        componentProps: {\n            hidden : isHidden\n        }\n    });\n});",
                },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2001198355203006466',
                style: { width: '100%' },
              },
            },
            {
              key: 'fd9c2957fb694bffaa33fa125bc0e140',
              field: 'withoutWoProduce',
              label: '无工单报工记录产出物',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 12,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#303030',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '55d03e0607bc4ea281a248fdcfc571bb',
              field: 'collectionSchemeId',
              label: '采集方案',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '无', value: '无' }],
                defaultSelect: '',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'ca8257a46070472e9639110b11f7f3bd',
              field: 'ratedWorkingHours',
              label: '额定工时',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                max: 100,
                step: 0.01,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '54078d1dd17c465983be38829aaa9969',
              field: 'collectionItem',
              label: '采集项',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: true,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '环境温度', value: '环境温度' }],
                defaultSelect: '',
                datasourceType: 'dic',
                params: { itemId: '2001194974510096385' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2001194974510096385',
                style: { width: '100%' },
              },
            },
            {
              key: 'e2c431530e954e53852f9a6026987e0d',
              field: 'active',
              label: '有效的',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 5,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#303030',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 2,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '',
        margin: '10px',
      },
    },
    {
      key: '55f159dd3d1e42e8af2af341bd543c2a',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'a0cfa452347845d696cb160c3bf86691',
              field: '',
              label: '文本',
              type: 'text',
              component: 'Text',
              colProps: { span: 24 },
              defaultValue: '工单质检',
              componentProps: {
                defaultValue: '工单质检',
                color: '',
                align: 'left',
                fontSize: 20,
                fontWeight: 'bold',
                fontFamily: 'Arial',
                fontStyle: 'normal',
                isShow: true,
                padding: '',
                margin: '10px',
                span: 7,
                style: {},
              },
            },
            {
              key: 'a8ad71f3a5334f79adcfd8c22d013598',
              field: 'qualityMode',
              label: '质检方式',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'dic',
                params: { itemId: '2001225699288457217' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {
                  change:
                    "let value = formModel.quality_mode;\nvar fieldConfigs = [\n    {field: 'qc_salary_type'},\n    {field: 'qc_salary_basis'},\n    {field: 'qc_base_qty'},\n    {field: 'qc_salary_unit'},\n    {field: 'qc_salary'},\n  {field: 'inspection_scheme'},\n  {field: 'inspection_department'},\n  {field: 'inspection_staff'},\n  {field: 'defect_processing'},\n    {field: 'zhi_jian_ji_xin_dan_wei9236'}\n  \n];\nfieldConfigs.forEach(function(config) {\n    var isHidden = false;\n\n    if (value == 1) {\n        isHidden = true;\n    }\n    formActionType.updateSchema({\n        field: config.field,\n        componentProps: {\n            hidden: isHidden\n        }\n    });\n});",
                },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2001225699288457217',
                style: { width: '100%' },
              },
            },
            {
              key: '9a8bade44b6a494ba761114ced745bcd',
              field: 'qcSchemeId',
              label: '质检采集方案',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '无', value: '无' }],
                defaultSelect: '',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'a1733daa77c64e4aa995a4a95cb37fdf',
              field: 'inspectionCollectionItem',
              label: '质检采集项',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '无', value: '无' }],
                defaultSelect: '',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '90b68d6c9492410a9a564ea5d0684e64',
              field: '',
              label: '文本',
              type: 'text',
              component: 'Text',
              colProps: { span: 24 },
              defaultValue: '质检计薪',
              componentProps: {
                defaultValue: '质检计薪',
                color: '',
                align: 'left',
                fontSize: 20,
                fontWeight: 'bold',
                fontFamily: 'Arial',
                fontStyle: 'normal',
                isShow: true,
                padding: '',
                margin: '10px',
                span: 7,
                style: {},
              },
            },
            {
              key: '1ae19160a0ac425e8e7923444ac67a5f',
              field: 'qcSalaryType',
              label: '质检计薪方式',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'dic',
                params: { itemId: '2001201026722996226' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {
                  change:
                    "// 获取计薪类型\nlet value = formModel.qc_salary_type;\n\n// 更新计薪单位字段\nfunction updateSalaryUnit() {\n    var unitValue = '';\n    \n    if (value == 1) {\n        unitValue = '产品单位';\n    } else if (value == 2) {\n        unitValue = '小时';\n    } else if (value == 3) {\n        unitValue = '次';\n    }\n    \n    // 更新计薪单位字段\n    formModel.qc_salary_unit = unitValue;\n    console.log('计薪单位已更新为:', unitValue);\n}\n\n// 更新计薪规则字段（拼接字段）\nfunction updateSalaryRule() {\n    // 获取相关字段值\n    var baseQty = formModel.qc_base_qty || '0';\n    var salaryUnit = formModel.qc_salary_unit || '';\n    var salary = formModel.qc_salary || '0';\n    \n    // 拼接规则：基数 + 单位 + 薪酬\n    var rule = '每 ' + baseQty + ' ' + salaryUnit + ' ' + salary + ' 元';\n    \n    // 更新计薪规则字段\n    formModel.zhi_jian_ji_xin_dan_wei9236 = rule;\n    console.log('计薪规则已更新为:', rule);\n}\n\n// 主要逻辑\nif (value == 1) {\n    // 类型为1时：启用计薪基础字段\n    formActionType.updateSchema({\n        field: 'qc_salary_basis',\n        componentProps: {\n            disabled: false,\n            required: true\n        }\n    });\n    \n    // 更新计薪单位\n    updateSalaryUnit();\n    \n} else {\n    // 其他类型时：禁用计薪基础字段\n    formActionType.updateSchema({\n        field: 'qc_salary_basis',\n        componentProps: {\n            disabled: true,\n            required: false\n        }\n    });\n    \n    // 更新计薪单位\n    updateSalaryUnit();\n}\n\n// 更新计薪规则\nupdateSalaryRule();",
                },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2001201026722996226',
                style: { width: '100%' },
              },
            },
            {
              key: '50e39cab7a8040df9c965cc9fd15684d',
              field: 'qcSalaryBasis',
              label: '质检工资依据',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: true,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'dic',
                params: { itemId: '2001226224419512321' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2001226224419512321',
                style: { width: '100%' },
              },
            },
            {
              key: '68fb0de7702a41af97590b2c5b2905d8',
              field: 'qcBaseQty',
              label: '质检计薪基数',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 1,
                min: 0,
                max: null,
                step: 0.01,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {
                  change:
                    "// 获取相关字段值\nvar baseQty = Number(formModel.qc_base_qty) || 0;\n\nvar salaryUnit = formModel.qc_salary_type || '';  \n\n\n// 薪酬\nvar salary = Number(formModel.qc_salary) || 0;\n\n\nvar salaryUnitText = '产品单位';  // 默认值\n\n\nif (salaryUnit === '1') {\n    salaryUnitText = '产品单位';\n} else if (salaryUnit === '2' ) {\n    salaryUnitText = '小时';\n} else if (salaryUnit === '3' ) {\n    salaryUnitText = '次';\n} \n\n\nvar rule = '';\n\n// 拼接规则\nrule = `每 ${baseQty} ${salaryUnitText} ${salary} 元`;\n\nformModel.zhi_jian_ji_xin_dan_wei9236 = rule;\nconsole.log('拼接结果:', rule);\n\nreturn rule;",
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '6a8b88a2b5564944b94a646f6ee7c893',
              field: 'qcSalaryUnit',
              label: '质检计薪单位',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '66c726149fb6468089c3863ecc624d76',
              field: 'qcSalary',
              label: '质检薪酬',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                max: null,
                step: 0.01,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {
                  change:
                    "// 获取相关字段值\nvar baseQty = Number(formModel.qc_base_qty) || 0;\n\nvar salaryUnit = formModel.qc_salary_type || '';  \n\n\n// 薪酬\nvar salary = Number(formModel.qc_salary) || 0;\n\n\nvar salaryUnitText = '产品单位';  // 默认值\n\n\nif (salaryUnit === '1') {\n    salaryUnitText = '产品单位';\n} else if (salaryUnit === '2' ) {\n    salaryUnitText = '小时';\n} else if (salaryUnit === '3' ) {\n    salaryUnitText = '次';\n} \n\n\nvar rule = '';\n\n// 拼接规则\nrule = `每 ${baseQty} ${salaryUnitText} ${salary} 元`;\n\nformModel.zhi_jian_ji_xin_dan_wei9236 = rule;\nconsole.log('拼接结果:', rule);\n\nreturn rule;",
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '07857cbe5b6d4d0582e9ecee53a4b0fb',
              field: 'zhiJianJiXinDanWei9236',
              label: '质检计薪规则',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '自动生成',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: true,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '94a5a7a3ad974df0b8d9083ef3fd72a2',
              field: '',
              label: '文本',
              type: 'text',
              component: 'Text',
              colProps: { span: 24 },
              defaultValue: '计薪规则',
              componentProps: {
                defaultValue: '计薪规则',
                color: '',
                align: 'left',
                fontSize: 20,
                fontWeight: 'bold',
                fontFamily: 'Arial',
                fontStyle: 'normal',
                isShow: true,
                padding: '',
                margin: '10px',
                span: 7,
                style: {},
              },
            },
            {
              key: 'a5bd776284ac4a87aa9be46eaf0398a4',
              field: 'salaryType',
              label: '计薪方式',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'dic',
                params: { itemId: '2001201026722996226' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {
                  change:
                    "// 获取计薪类型\nlet value = formModel.salary_type;\n\nfunction updateSalaryUnit1() {\n    var unitValue = '';\n    \n    if (value == 1) {\n        unitValue = '产品单位';\n    } else if (value == 2) {\n        unitValue = '小时';\n    } else if (value == 3) {\n        unitValue = '次';\n    }\n    formModel.salary_unit = unitValue;\n}\n\nfunction updateSalaryRule1() {\n    var baseQty = formModel.base_qty || '0';\n    var salaryUnit = formModel.salary_unit || '';\n    var salary = formModel.salary || '0';\n    \n    // 拼接规则：基数 + 单位 + 薪酬\n    var rule = '每 ' + baseQty + ' ' + salaryUnit + ' ' + salary + ' 元';\n    formModel.ji_xin_gui_ze8609 = rule;\n}\nif (value == 1) {\n    formActionType.updateSchema({\n        field: 'salary_basis',\n        componentProps: {\n            disabled: false,\n            required: true\n        }\n    });\n    updateSalaryUnit1();\n} else {\n    formActionType.updateSchema({\n        field: 'salary_basis',\n        componentProps: {\n            disabled: true,\n            required: false\n        }\n    });\n    updateSalaryUnit1();\n}\nupdateSalaryRule1();",
                },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2001201026722996226',
                style: { width: '100%' },
              },
            },
            {
              key: 'bc6833c275f4422eb5041773aee38770',
              field: 'baseQty',
              label: '计薪基数',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 1,
                min: 0,
                max: null,
                step: 0.01,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {
                  change:
                    "var baseQty = Number(formModel.base_qty) || 0;\nvar salaryUnit = formModel.salary_type || '';  \nvar salary = Number(formModel.salary) || 0;\nvar salaryUnitText = '产品单位';  \nif (salaryUnit === '1') {\n    salaryUnitText = '产品单位';\n} else if (salaryUnit === '2' ) {\n    salaryUnitText = '小时';\n} else if (salaryUnit === '3' ) {\n    salaryUnitText = '次';\n} \nvar rule = '';\nrule = `每 ${baseQty} ${salaryUnitText} ${salary} 元`;\nformModel.ji_xin_gui_ze8609 = rule;\n",
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'dac1c00dd9744d95a7c16989202f5f54',
              field: 'salaryUnit',
              label: '计薪单位',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'f92292be8eec47cd94d5055e0ea5c9db',
              field: 'salary',
              label: '薪酬',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                max: null,
                step: 0.01,
                maxlength: null,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {
                  change:
                    "var baseQty = Number(formModel.base_qty) || 0;\nvar salaryUnit = formModel.salary_type || '';  \nvar salary = Number(formModel.salary) || 0;\nvar salaryUnitText = '产品单位';  \nif (salaryUnit === '1') {\n    salaryUnitText = '产品单位';\n} else if (salaryUnit === '2' ) {\n    salaryUnitText = '小时';\n} else if (salaryUnit === '3' ) {\n    salaryUnitText = '次';\n} \nvar rule = '';\nrule = `每 ${baseQty} ${salaryUnitText} ${salary} 元`;\nformModel.ji_xin_gui_ze8609 = rule;\n",
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '56db3f9fdea846c18f922aae91cd3fab',
              field: 'jiXinGuiZe8609',
              label: '计薪规则',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '自动生成',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: true,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 2,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '',
        margin: '10px',
      },
    },
    {
      key: '58a450e4729f4fdeb68390c172411808',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'd542a6a28b79466e94cfb1c723aee4c1',
              field: '',
              label: '文本',
              type: 'text',
              component: 'Text',
              colProps: { span: 24 },
              defaultValue: '质检单',
              componentProps: {
                defaultValue: '质检单',
                color: '',
                align: 'left',
                fontSize: 20,
                fontWeight: 'bold',
                fontFamily: 'Arial',
                fontStyle: 'normal',
                isShow: true,
                padding: '10px',
                margin: '10px',
                span: 7,
                style: {},
              },
            },
            {
              key: '2f4a0d9bd5324225b8785cc2f3eb9085',
              field: 'inspectionScheme',
              label: '质检方案',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '', value: '无' }],
                defaultSelect: '',
                datasourceType: 'staticData',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '9cdf176c0d554e358413156117e228cf',
              field: 'inspectionDepartment',
              label: '质检部门',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getList',
                  method: 'GET',
                  apiId: '484584e786864e0f90ec8e4eb84fa93a',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_department";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '3d977bcdee6c41c8a5e27b42bb2ee674',
              field: 'inspectionStaff',
              label: '质检人员',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'api',
                params: null,
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getEmployeeList',
                  method: 'GET',
                  apiId: 'copy1765432049337d61208',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,name as label from roke_employee where active = 1 and delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '93d054800285479f9e805c270fffdb8a',
              field: 'defectProcessing',
              label: '不良品处理',
              type: 'checkbox',
              component: 'ApiCheckboxGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 9,
                showLabel: true,
                disabled: false,
                staticOptions: [{ key: 1, label: '', value: '1' }],
                datasourceType: 'staticData',
                defaultSelect: '',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                params: null,
                style: {},
              },
            },
          ],
        },
        { span: 6, list: [] },
        { span: 6, list: [] },
      ],
      componentProps: {
        gutter: 2,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '',
        margin: '10px',
      },
    },
    {
      key: '24f0714c9f3a4242b1bcefff04bb7314',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '作业规范',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '5a5e71d4a88f45668eea7d27390cfc5f',
              label: '',
              field: 'rokeProcessSpecList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'rokeProcessSpecList',
                columns: [
                  {
                    key: 'bc410dc718a64431b1e475036a2c7e19',
                    title: '内容',
                    dataIndex: 'content',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: true,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'e3a097a002004e8dab41baed0ab02728',
                    title: '标题',
                    dataIndex: 'title',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: true,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '7dc949cc551d42969d98921847ca4178',
                    title: '附件数量',
                    dataIndex: 'attachmentCount',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: 100,
                      step: 1,
                      maxlength: null,
                      disabled: true,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: true,
                isShowDelete: true,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 24,
          name: '作业指导图片',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: 'f0db1f4ee6254dd58b8f6e5f66ab7030',
              field: '',
              label: '',
              type: 'grid',
              colProps: { span: 24 },
              component: 'Grid',
              children: [
                {
                  span: 12,
                  list: [
                    {
                      key: 'e504b345eb8e4336b233abeb7f76cdb5',
                      field: 'document',
                      label: '作业指导',
                      type: 'input',
                      component: 'Input',
                      colProps: { span: 24 },
                      defaultValue: '',
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: '',
                        placeholder: '请输入作业指导',
                        maxlength: null,
                        prefix: '',
                        suffix: '',
                        addonBefore: '',
                        addonAfter: '',
                        disabled: false,
                        allowClear: false,
                        showLabel: true,
                        required: false,
                        rules: [],
                        events: {},
                        listStyle: '',
                        isSave: false,
                        isShow: true,
                        scan: false,
                        bordered: true,
                        isShowAi: false,
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                    {
                      key: 'd35972c7c2884f2481e4432f32ce8276',
                      field: 'attachmentCount',
                      label: '作业指导数量',
                      type: 'number',
                      component: 'InputNumber',
                      colProps: { span: 24 },
                      defaultValue: 0,
                      componentProps: {
                        width: '100%',
                        span: 7,
                        defaultValue: 0,
                        min: 0,
                        max: 100,
                        step: 1,
                        maxlength: null,
                        disabled: true,
                        showLabel: true,
                        controls: true,
                        required: false,
                        subTotal: false,
                        isShow: true,
                        rules: [],
                        events: {},
                        tooltipConfig: { visible: false, title: '提示文本' },
                        style: { width: '100%' },
                      },
                    },
                  ],
                },
                { span: 12, list: [] },
              ],
              componentProps: {
                gutter: 16,
                justify: 'start',
                align: 'top',
                isShow: true,
                showBorder: false,
                bordercolor: '#d9d9d9',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                padding: '10px',
                margin: '10px',
              },
            },
          ],
        },
        {
          span: 24,
          name: '子工序',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: 'b02f8a3e28b24689bb5a311945bb2519',
              label: '',
              field: 'rokeProcessChildList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'rokeProcessChildList',
                columns: [
                  {
                    key: 'fd222a1216344ebda66dd2cdd586e8ac',
                    title: '子工序',
                    dataIndex: 'childProcessId',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '请选择下拉选择子工序',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [{ key: 1, label: '工序1', value: '工序1' }],
                      defaultSelect: null,
                      datasourceType: 'api',
                      params: null,
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/jcxx/getProcessList',
                        method: 'GET',
                        apiId: 'copy1766022481900d48902',
                        apiParams: [
                          {
                            key: '1',
                            title: 'Query Params',
                            tableInfo: [
                              {
                                name: 'processType',
                                value: '2',
                                description: null,
                                required: true,
                                dataType: null,
                                type: null,
                                defaultValue: null,
                                validateType: null,
                                error: null,
                                expression: null,
                                children: null,
                                bindType: 'value',
                              },
                            ],
                          },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select id as value,name as label from roke_process where process_type = #{processType} and delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {
                        change:
                          "const row = formModel.roke_process_childList?.[index];\n\nif (!row || !row.child_process_id) {\n  console.warn('行数据或 child_process_id 不存在', row);\n  return;\n}\n\nformActionType.httpRequest({\n  requestType: 'get',\n  requestUrl: '/magic-api/jcxx/getProcess',\n  params: {\n    id: row.child_process_id\n  },\n  errorMessageMode: 'none'\n}).then(res => {\n\n  const list = res?.data || res;\n\n  if (Array.isArray(list) && list.length > 0) {\n    row.child_rated_wh = list[0].rated_working_hours;\n    row.note = list[0].note;\n  } else {\n    formActionType.showMessage('未查询到工序信息');\n  }\n\n}).catch(err => {\n  console.error('接口请求异常：', err);\n  formActionType.showMessage('接口请求异常');\n});\n",
                      },
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: 'ef75818985694e619da0aefc865353ce',
                    title: '额定工时',
                    dataIndex: 'childRatedWh',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: null,
                      step: 0.01,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '72fed4a008e74833aa9d0e11337e1794',
                    title: '编号',
                    dataIndex: 'sequence',
                    componentType: 'InputNumber',
                    defaultValue: null,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: null,
                      min: 0,
                      max: 100,
                      step: 1,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '1fce07a52dc64ab6ad34ebce76b7b05c',
                    title: '描述',
                    dataIndex: 'note',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: true,
                isShowDelete: true,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 0,
          name: '关键物料',
          prefix: null,
          suffix: null,
          activeColor: null,
          folderId: null,
          imageUrl: null,
          conFolderId: null,
          conImageUrl: null,
          list: [
            {
              key: '27fb7435f48c42da8a639e1cc5396945',
              label: '表格组件',
              field: 'rokeMaterialDetailsList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'rokeMaterialDetailsList',
                columns: [
                  {
                    key: '031cc7cac3f74e85b3549c71853aaae7',
                    title: '物料',
                    dataIndex: 'productId',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '请选择下拉选择',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      params: null,
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/jcxx/getProductList',
                        method: 'GET',
                        apiId: 'copy1766041321701d99854',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select id as value,name as label from roke_product where delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: '0b36ff88c28140c696c70f25a232a146',
                    title: '数量',
                    dataIndex: 'quantity',
                    componentType: 'InputNumber',
                    defaultValue: 1,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 1,
                      min: 0,
                      max: null,
                      step: 0.01,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '3c191da8c5674b12bd8ab54c175bd57b',
                    title: '损耗率%',
                    dataIndex: 'attritionRate',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      max: null,
                      step: 0.01,
                      maxlength: null,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'ca1890169d984eea96483944efba3da2',
                    title: '必投',
                    dataIndex: 'mustInvest',
                    componentType: 'Switch',
                    defaultValue: 1,
                    componentProps: {
                      span: '',
                      defaultValue: 1,
                      checkedChildren: '',
                      unCheckedChildren: '',
                      checkedColor: '#1C8DFF',
                      unCheckedColor: '#bbbdbf',
                      showLabel: true,
                      disabled: false,
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '9483ab03c72146e9b2c06c21ac33fdad',
                    title: '物料工艺路线',
                    dataIndex: 'routingId',
                    componentType: 'XjrSelect',
                    componentProps: {
                      width: '100%',
                      span: '',
                      placeholder: '请选择下拉选择',
                      showLabel: true,
                      showSearch: false,
                      isMultiple: false,
                      clearable: false,
                      disabled: false,
                      staticOptions: [
                        { key: 1, label: 'Option 1', value: 'Option 1' },
                        { key: 2, label: 'Option 2', value: 'Option 2' },
                        { key: 3, label: 'Option 3', value: 'Option 3' },
                      ],
                      defaultSelect: '',
                      datasourceType: 'api',
                      params: null,
                      labelField: 'label',
                      valueField: 'value',
                      apiConfig: {
                        path: '/jcxx/getRoutingList',
                        method: 'GET',
                        apiId: 'copy1766114285962d24088',
                        apiParams: [
                          { key: '1', title: 'Query Params', tableInfo: [] },
                          { key: '2', title: 'Header', tableInfo: [] },
                          { key: '3', title: 'Body' },
                        ],
                        script:
                          'var sql="select id as value,name as label from roke_routing where delete_mark = 0";\r\nreturn db.select(sql);',
                      },
                      dicOptions: [],
                      required: false,
                      rules: [],
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'border: 0'",
                    },
                  },
                  {
                    key: 'dc2cf962abc940b181c90207fc569cc3',
                    title: '领料位置',
                    dataIndex: 'materialRequisitionLocation',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入领料位置',
                      maxlength: null,
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '174c1b2cbfb44890aa2a997cda66eb93',
                    title: '备注',
                    dataIndex: 'remark',
                    componentType: 'InputTextArea',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入备注',
                      maxlength: null,
                      rows: 4,
                      autoSize: false,
                      showCount: false,
                      disabled: false,
                      showLabel: true,
                      allowClear: false,
                      required: false,
                      isShow: true,
                      isShowAi: false,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  { title: '操作', key: 'action', fixed: 'right', width: '50px' },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: false,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: true,
                isShowDelete: true,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
    {
      key: '03c19c5ac95b4d139d8380ede64f14ff',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '04ae7a540acd4c46949c6fd53e652a45',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 0,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 1,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
