import {
  MesProductSetupModel,
  MesProductSetupPageParams,
  MesProductSetupPageResult,
} from './model/ProductSetUpModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/productsetup/page',
  List = '/mes/productsetup/list',
  Info = '/mes/productsetup/info',
  MesProductSetup = '/mes/productsetup',
}

/**
 * @description: 查询MesProductSetup分页列表
 */
export async function getMesProductSetupPage(
  params: MesProductSetupPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesProductSetupPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProductSetup信息
 */
export async function getMesProductSetup(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductSetupModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProductSetup
 */
export async function addMesProductSetup(
  mesProductSetup: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesProductSetup,
      params: mesProductSetup,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProductSetup
 */
export async function updateMesProductSetup(
  mesProductSetup: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesProductSetup,
      params: mesProductSetup,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProductSetup（批量删除）
 */
export async function deleteMesProductSetup(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProductSetup,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
