import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface IotDicPageListParams {
  groupId?: string; //分组id
}

/**
 * @description: Request list interface parameters
 */
export type IotDicPageListSearchModel = BasicPageParams & IotDicPageListParams;

export interface IotDicPageListModel {
  id: string;
  groupId: string; //分组id
  linkId: string; //连接id
  name: string; //字典名
  getStr: string; //获取字符串
  trans: string; //转换规则
  saveType: number; //保存类型 0 不存储 1 改变值 存储  2 间隔  3 每次
  saveValue: string; //保存类型为 1  就存储的 改变值  2 存储间隔值
}

export interface IotDicModel {
  id: string;
  groupId: string; //分组id
  linkId: string; //连接id
  name: string; //字典名
  getStr: string; //获取字符串
  trans: string; //转换规则
  saveType: number; //保存类型 0 不存储 1 改变值 存储  2 间隔  3 每次
  saveValue: string; //保存类型为 1  就存储的 改变值  2 存储间隔值
}

/**
 * @description: Request list return value
 */
export type IotDicPageListResultModel = BasicFetchResult<IotDicPageListModel>;

/*******************物联网连接******************* */
export interface IotLinkPageListParams {
  name?: string;
}

/**
 * @description: Request list interface parameters
 */
export type IotLinkPageListSearchModel = BasicPageParams & IotLinkPageListParams;

export interface IotLinkPageListModel {
  id: string;
  name: string; //链接名称

  protocolType: number; //协议类型
  hostUrl: string; //物联网数据源地址
  username: string; //用户名
  password: string; //密码
  clientId: string; //客户端id
  topic: string; //订阅主题
  remark: string; //备注
}

export interface IotLinkModel {
  id: string;
  name: string; //链接名称

  protocolType: number; //协议类型
  hostUrl: string; //物联网数据源地址
  username: string; //用户名
  password: string; //密码
  clientId: string; //客户端id
  topic: string; //订阅主题
  remark: string; //备注
}

/**
 * @description: Request list return value
 */
export type IotLinkPageListResultModel = BasicFetchResult<IotLinkPageListModel>;

/*******************分组******************* */
export interface IotGroupPageListParams {
  name?: string;
}

/**
 * @description: Request list interface parameters
 */
export type IotGroupPageListSearchModel = BasicPageParams & IotGroupPageListParams;

export interface IotGroupPageListModel {
  id: string;
  name: string; //分组名称
  sortCode: number; //排序
}

export interface IotGroupModel {
  id: string;
  name: string; //分组名称
  sortCode: number; //排序
}

/**
 * @description: Request list return value
 */
export type IotGroupPageListResultModel = BasicFetchResult<IotGroupPageListModel>;
