import {
  CaseErpApplyModel,
  CaseErpApplyPageParams,
  CaseErpApplyPageResult,
} from './model/PurchasingApplyModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/caseErpPurchaseApply/caseErpPurchaseApply/page',
  List = '/caseErpPurchaseApply/caseErpPurchaseApply/list',
  Info = '/caseErpPurchaseApply/caseErpPurchaseApply/info',
  CaseErpApply = '/caseErpPurchaseApply/caseErpPurchaseApply',
  Export = '/caseErpPurchaseApply/caseErpPurchaseApply/export',
}

/**
 * @description: 查询CaseErpApply分页列表
 */
export async function getCaseErpApplyPage(
  params: CaseErpApplyPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<CaseErpApplyPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询CaseErpApply列表
 */
export async function getCaseErpApplyList(
  params: CaseErpApplyPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<CaseErpApplyPageResult>(
    {
      url: Api.List,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取CaseErpApply信息
 */
export async function getCaseErpApply(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<CaseErpApplyModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增CaseErpApply
 */
export async function addCaseErpApply(caseErpApply: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.CaseErpApply,
      params: caseErpApply,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新CaseErpApply
 */
export async function updateCaseErpApply(
  caseErpApply: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.CaseErpApply,
      params: caseErpApply,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除CaseErpApply（批量删除）
 */
export async function deleteCaseErpApply(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.CaseErpApply,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出CaseErpApply
 */
export async function exportCaseErpApply(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
