
export default function (hiprint) {
  return function (defaultConfigs) {
   
    var addElementTypes = function (context) {
      context.removePrintElementTypes("defaultModule");
      // var defaultConfigs = [];
      // console.log('defaultList: ', defaultList);
      // defaultList.forEach(function(ele){
      //   defaultConfigs.push({
      //     tid: ele.tid,
      //     title: ele.title,
      //       type: 'table',
      //       options: {
      //         field: ele.tableName,
      //         tableHeaderRepeat: 'first',
      //         tableFooterRepeat: 'last',
      //         fields: [
      //           {text: '名称', field: 'NAME'},
      //           {text: '数量', field: 'SL'},
      //           {text: '规格', field: 'GG'},
      //           {text: '条码', field: 'TM'},
      //           {text: '单价', field: 'DJ'},
      //           {text: '金额', field: 'JE'},
      //         ]
      //       },
      //       editable: true,
      //       columnDisplayEditable: true,//列显示是否能编辑
      //       columnDisplayIndexEditable: true,//列顺序显示是否能编辑
      //       columnTitleEditable: true,//列标题是否能编辑
      //       columnResizable: true, //列宽是否能调整
      //       columnAlignEditable: true,//列对齐是否调整
      //       isEnableEditField: true, //编辑字段
      //       isEnableContextMenu: true, //开启右键菜单 默认true
      //       isEnableInsertRow: true, //插入行
      //       isEnableDeleteRow: true, //删除行
      //       isEnableInsertColumn: true, //插入列
      //       isEnableDeleteColumn: true, //删除列
      //       isEnableMergeCell: true, //合并单元格
      //       columns: [
      //         [
      //           {title: '名称', align: 'center', field: 'NAME', width: 150},
      //           {title: '数量', align: 'center', field: 'SL', width: 80},
      //           {title: '规格', align: 'center', field: 'GG', width: 80, checked: false},
      //           {title: '条码', align: 'center', field: 'TM', width: 100, checked: false},
      //           {title: '单价', align: 'center', field: 'DJ', width: 100},
      //           {title: '金额', align: 'center', field: 'JE', width: 100, checked: false},
      //         ],
      //       ],
      //   });
      // });
      context.addPrintElementTypes("defaultModule", [
        new hiprint.PrintElementTypeGroup("常规", [
          {
            tid: "defaultModule.text",
            title: "文本",
            data: "",
            type: "text"
          },
          {
            tid: "defaultModule.image",
            title: "图片",
            data: "",
            type: "image"
          },
          {
            tid: "defaultModule.longText",
            title: "长文",
            data: "155123456789",
            type: "longText"
          },
          {
            tid: "defaultModule.html",
            title: "html",
            formatter: function (data, options) {
              return '<div style="height:50pt;width:50pt;background:red;border-radius: 50%;"></div>';
            },
            type: "html"
          },
          {
            tid: "defaultModule.customText",
            title: "自定义文本",
            customText: "自定义文本",
            custom: true,
            type: "text"
          },
          {
            tid: 'defaultModule.barcode', title: '条形码', data: 'test data', type: 'barcode',
            options: {
              field: '',// 配置类型为api的时候使用
              configType:'',//配置类型 '' 'api'
              barcodeFormat:'CODE128',//格式  CODE128  CODE39  EAN13
              codeContent: 'test data',//内容
              width:200,
              height: 72,
              fontSize: 12,
              lineHeight: 18,
              textType: "barcode",
              barcodeDisplayText:'show'//显示文本
            }
          },
          {
            tid: 'defaultModule.qrcode', title: '二维码', data: 'test data', type: 'qrcode',
            options: {
              field: 'qrcode',
              qrcodeContent: 'test data',
              width:100,
              height: 100,
              fontSize: 12,
              lineHeight: 18,
              textType: "qrcode"
            }
          },
          ...defaultConfigs
        ]),
        new hiprint.PrintElementTypeGroup("辅助", [
          {
            tid: "defaultModule.hline",
            title: "横线",
            type: "hline"
          },
          {
            tid: "defaultModule.vline",
            title: "竖线",
            type: "vline"
          },
          {
            tid: "defaultModule.rect",
            title: "矩形",
            type: "rect"
          },
          {
            tid: "defaultModule.oval",
            title: "椭圆",
            type: "oval"
          }
        ])
      ]);
    };
    return {
      addElementTypes: addElementTypes
    };
  };
};
