import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import { OperationManagementListModel } from './model';

enum Api {
  Design = '/system/operation-manage',
  Page = '/system/operation-manage/page',
  Info = '/system/operation-manage/info',
  List = '/system/operation-manage/list',
}
/**
 * @description: 查询不分页
 */
export async function getOperationManagementList(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<OperationManagementListModel>(
    {
      url: Api.List,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询详情
 */
export async function getOperationManagementInfo(id, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<OperationManagementListModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询所有规则文件列表（分页）
 */
export async function getOperationManagementPage(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除
 */
export async function deleteOperationManagement(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Design,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 新增
 */
export async function addOperationManagement(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.post(
    {
      url: Api.Design,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 编辑
 */
export async function updateOperationManagement(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.put(
    {
      url: Api.Design,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
