import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: RokeProcess分页参数 模型
 */
export interface RokeProcessPageParams extends BasicPageParams {
  code: string;

  name: string;

  categoryId: string;

  collectionSchemeId: string;

  note: string;
}

/**
 * @description: RokeProcess分页返回值模型
 */
export interface RokeProcessPageModel {
  id: string;

  code: string;

  name: string;

  categoryId: string;

  collectionSchemeId: string;
}

/**
 * @description: RokeProcess表类型
 */
export interface RokeProcessModel {
  id: string;

  deleteMark: string;

  messageMainAttachmentId: string;

  name: string;

  code: string;

  categoryId: string;

  processType: string;

  internalCode: string;

  active: string;

  withoutWoProduce: string;

  note: string;

  ratedWorkingHours: string;

  companyId: string;

  isPress: string;

  prepareWorkHours: string;

  collectionSchemeId: string;

  qualityMode: string;

  qcSchemeId: string;

  isQuality: string;

  salaryType: string;

  baseQty: string;

  salaryUnit: string;

  salary: string;

  salaryCode: string;

  qcSalaryBasis: string;

  qcSalaryType: string;

  qcBaseQty: string;

  qcSalaryUnit: string;

  qcSalary: string;

  qcSalaryCode: string;

  defaultReporter: string;

  collectionItem: string;

  inspectionCollectionItem: string;

  inspectionScheme: string;

  inspectionDepartment: string;

  inspectionStaff: string;

  defectProcessing: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  zyzdFile: string;

  zyzdtpFile: string;

  mesProcessProductList?: MesProcessProductModel;

  mesCollectionItemList?: MesCollectionItemModel;
}

/**
 * @description: MesProcessProduct表类型
 */
export interface MesProcessProductModel {
  id: string;

  deleteMark: string;

  productId: string;

  processId: string;

  erpid: string;

  bz: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;

  isFeeding: string;

  number: string;

  name: string;

  code: string;
}

/**
 * @description: MesCollectionItem表类型
 */
export interface MesCollectionItemModel {
  id: string;

  code: string;

  name: string;

  required: string;

  categoryId: string;

  contentType: string;

  dataType: string;

  dictId: string;

  relatedModelId: string;

  relatedModelName: string;

  relatedModelDomain: string;

  standardValue: string;

  upperValue: string;

  lowerValue: string;

  note: string;

  companyId: string;

  qualityCategoryId: string;

  analysisMethod: string;

  qualityMethodId: string;

  destructive: string;

  keyItem: string;

  deleteMark: string;

  createDate: string;

  createUserId: string;

  modifyDate: string;

  modifyUserId: string;
}

/**
 * @description: RokeProcess分页返回值结构
 */
export type RokeProcessPageResult = BasicFetchResult<RokeProcessPageModel>;
