import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface CollectionPageListParams {
  keyword?: string; //关键字
  receivedStartTime?: string; //计划回款开始时间
  receivedEndTime?: string; //计划回款结束时间
  finallyStartTime?: string; //最迟回款开始时间
  finallyEndTime?: string; //最迟回款结束时间
}

export interface CollectionAddParamsModel {
  customerId?: string; //客户名称
  waitAmount?: string; //计划回款金额
  receivedDate?: string; //计划回款日期
  finallyDate?: string; //最迟回款日期
  title?: string; //合同标题
  principalIds?: string; //合同负责人
  filePath?: string; //合同附件
}

export interface CollectionUpdateParamsModel {
  id: string; //详情id
  customerId?: string; //客户名称
  waitAmount?: string; //计划回款金额
  receivedDate?: string; //计划回款日期
  finallyDate?: string; //最迟回款日期
  title?: string; //合同标题
  principalIds?: string; //合同负责人
  filePath?: string; //合同附件
}

export interface CollectionListModel {
  id: string; //详情id
  name?: string; //客户名称
  waitAmount?: string; //计划回款金额
  alreadyAmount?: string; //已回款金额
  unpaidAmount?: string; //未回款金额
  receivedDate?: string; //计划回款日期
  finallyDate?: string; //最迟回款日期
  overDay?: string; //逾期天数
  title?: string; //合同标题
  principalNames?: string; //合同负责人
  createUserName: string; //添加人
  createDate: string; //创建日期
  state: number; //状态
}

export interface CollectionDetailAddParamsModel {
  gatherId?: string; //id
  amountCollect: string; //回款金额
  date: string; //回款时间
  remark?: string; //备注
  filePath?: string; //附件
}

export interface CollectionDetailUpdateParamsModel {
  id: string; //详情id
  gatherId: string; //id
  amountCollect: string; //回款金额
  date: string; //回款时间
  remark?: string; //备注
  filePath?: string; //附件
}

export interface CollectionDetailInfoModel {
  id: string; //详情id
  name: string; //名称
  waitAmount: string; //计划回款金额
  receivedDate: string; //计划回款日期
  finallyDate?: string; //最迟回款日期
  title?: string; //合同标题
  principalNames?: string; //合同负责人
  caseErpCustomerGatherDetailVoList: CollectionDetailInfo[];
}

export interface CollectionDetailInfo {
  id: string; //详情id
  amountCollect: string; //回款金额
  date: string; //回款时间
  remark?: string; //备注
  createDate?: string; //创建时间
  createUserName?: string; //创建人
}

export type CollectionPageListSearchModel = BasicPageParams & CollectionPageListParams;
export type CollectionPageListResultModel = BasicFetchResult<CollectionListModel>;
