
import { MesEquipmentRepairPageModel, MesEquipmentRepairPageParams, MesEquipmentRepairPageResult } from './model/SbbxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/sbgl/sbbx/page',
  List = '/sbgl/sbbx/list',
  Info = '/sbgl/sbbx/info',
  MesEquipmentRepair = '/sbgl/sbbx',
  
  
  
}

/**
 * @description: 查询MesEquipmentRepair分页列表
 */
export async function getMesEquipmentRepairPage(params: MesEquipmentRepairPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentRepairPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesEquipmentRepair信息
 */
export async function getMesEquipmentRepair(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesEquipmentRepairPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesEquipmentRepair
 */
export async function addMesEquipmentRepair(mesEquipmentRepair: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesEquipmentRepair,
      params: mesEquipmentRepair,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesEquipmentRepair
 */
export async function updateMesEquipmentRepair(mesEquipmentRepair: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesEquipmentRepair,
      params: mesEquipmentRepair,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesEquipmentRepair（批量删除）
 */
export async function deleteMesEquipmentRepair(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesEquipmentRepair,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




