import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  IotDicModel,
  IotDicPageListModel,
  IotDicPageListParams,
  IotGroupModel,
  IotGroupPageListModel,
  IotGroupPageListParams,
  IotGroupPageListResultModel,
  IotLinkPageListModel,
  IotLinkPageListParams,
  IotLinkPageListResultModel,
} from './model';
enum Api {
  Dic = '/iot/dic',
  DicInfo = '/iot/dic/info',
  DicList = '/iot/dic/list',
  DicPage = '/iot/dic/page',
  DicGroup = '/iot/group',
  DicGroupInfo = '/iot/group/info',
  DicGroupList = '/iot/group/list',
  DicGroupPage = '/iot/group/page',
  Link = '/iot/link',
  LinkTest = '/iot/link/test',
  LinkInfo = '/iot/link/info',
  LinkList = '/iot/link/list',
  LinkPage = '/iot/link/page',
}

/**
 * @description: 查询字典 不分页
 */
export async function getIotDicList(
  params?: IotDicPageListParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<IotDicPageListModel[]>(
    {
      url: Api.DicList,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询字典 分页
 */
export async function getIotDicPageList(
  params: IotDicPageListParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<IotDicPageListModel>(
    {
      url: Api.DicPage,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除 字典项（批量删除）
 */
export async function deleteIotDic(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Dic,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增 字典项
 */
export async function addIotDic(dic: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.Dic,
      data: dic,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增 字典项
 */
export async function updateIotDic(dic: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.Dic,
      data: dic,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取 字典项
 */
export async function getIotDic(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<IotDicModel>(
    {
      url: Api.DicInfo,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/******************************************************** */

/**
 * @description: 查询字典分组 不分页
 */
export async function getIotGroupList(
  params?: IotGroupPageListParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<IotGroupPageListModel[]>(
    {
      url: Api.DicGroupList,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询字典分组 分页
 */
export async function getIotGroupPageList(
  params: IotGroupPageListParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<IotGroupPageListResultModel>(
    {
      url: Api.DicGroupPage,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除 字典项（批量删除）
 */
export async function deleteIotGroup(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.DicGroup,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增 字典项
 */
export async function addIotGroup(dic: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.DicGroup,
      data: dic,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增 字典项
 */
export async function updateIotGroup(dic: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.Dic,
      data: dic,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取 字典项
 */
export async function getIotGroup(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<IotGroupModel>(
    {
      url: Api.DicGroupInfo,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/******************************************************** */

/**
 * @description: 查询链接 不分页
 */
export async function getIotLinkList(
  params?: IotLinkPageListParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<IotLinkPageListModel[]>(
    {
      url: Api.LinkList,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询链接 分页
 */
export async function getIotLinkPageList(
  params: IotLinkPageListParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<IotLinkPageListResultModel>(
    {
      url: Api.LinkPage,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除 字典项（批量删除）
 */
export async function deleteIotLink(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Link,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增 字典项
 */
export async function addIotLink(dic: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.Link,
      data: dic,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增 字典项
 */
export async function updateIotLink(dic: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.Link,
      data: dic,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取 字典项
 */
export async function getIotLink(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<IotGroupModel>(
    {
      url: Api.LinkInfo,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 测试iot链接是否可以链接
 */
export async function testIotLink(dic: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.LinkTest,
      data: dic,
    },
    {
      errorMessageMode: mode,
    },
  );
}
