import { XjrMyappPageModel, XjrMyappPageParams, XjrMyappPageResult } from './model/MyappModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/version/myapp/page',
  List = '/version/myapp/list',
  Info = '/version/myapp/info',
  XjrMyapp = '/version/myapp',
  Preview = '/version/app-store/info',
}

/**
 * @description: 查询XjrMyapp分页列表
 */
export async function getXjrMyappPage(
  params: XjrMyappPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<XjrMyappPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取XjrMyapp信息
 */
export async function getXjrMyapp(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<XjrMyappPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增XjrMyapp
 */
export async function addXjrMyapp(xjrMyapp: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.XjrMyapp,
      params: xjrMyapp,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新XjrMyapp
 */
export async function updateXjrMyapp(xjrMyapp: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.XjrMyapp,
      params: xjrMyapp,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除XjrMyapp（批量删除）
 */
export async function deleteXjrMyapp(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.XjrMyapp,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取应用预览信息
 */
export async function getAppPreviewInfo(param, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Preview,
      params: param,
    },
    {
      errorMessageMode: mode,
    },
  );
}
