import {
  ModalManagePageModel,
  ModalManagePageParams,
  ModalManagePageResult,
} from './model/ModalManageModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/dataconfig/modalmanage/page',
  List = '/dataconfig/modalmanage/list',
  Info = '/dataconfig/modalmanage/info',
  ModalManage = '/dataconfig/modalmanage',
}

/**
 * @description: 查询ModalManage分页列表
 */
export async function getModalManagePage(
  params: ModalManagePageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<ModalManagePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询ModalManage不分页列表
 */
export async function getModalManageList(params?, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.List,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 获取ModalManage信息
 */
export async function getModalManage(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<ModalManagePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增ModalManage
 */
export async function addModalManage(modalManage: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.ModalManage,
      params: modalManage,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新ModalManage
 */
export async function updateModalManage(modalManage: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.ModalManage,
      params: modalManage,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除ModalManage（批量删除）
 */
export async function deleteModalManage(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.ModalManage,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
