import {
  MesWarehouseOutModel,
  MesWarehouseOutPageParams,
  MesWarehouseOutPageResult,
} from './model/WarehouseOutModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/warehouseout/page',
  List = '/mes/warehouseout/list',
  Info = '/mes/warehouseout/info',
  MesWarehouseOut = '/mes/warehouseout',

  Export = '/mes/warehouseout/export',
}

/**
 * @description: 查询MesWarehouseOut分页列表
 */
export async function getMesWarehouseOutPage(
  params: MesWarehouseOutPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesWarehouseOutPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseOut信息
 */
export async function getMesWarehouseOut(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseOutModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseOut
 */
export async function addMesWarehouseOut(
  mesWarehouseOut: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseOut,
      params: mesWarehouseOut,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseOut
 */
export async function updateMesWarehouseOut(
  mesWarehouseOut: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseOut,
      params: mesWarehouseOut,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseOut（批量删除）
 */
export async function deleteMesWarehouseOut(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseOut,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

export async function finishMesWarehouseOut(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: '/mes/warehouseout/finish/' + id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出MesWarehouseOut
 */
export async function exportMesWarehouseOut(params?: object, mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
