import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesWarehouseChgapply分页参数 模型
 */
export interface MesWarehouseChgapplyPageParams extends BasicPageParams {
  dataCode: string;

  dataName: string;

  dataDate: string;

  dataUnit: string;

  dataUser: string;

  dataPhone: string;

  inStorage: string;

  outStorage: string;
}

/**
 * @description: MesWarehouseChgapply分页返回值模型
 */
export interface MesWarehouseChgapplyPageModel {
  id: string;

  dataCode: string;

  dataName: string;

  dataDate: string;

  dataUnit: string;

  dataUser: string;

  dataPhone: string;

  inStorage: string;

  outStorage: string;

  remark: string;
}

/**
 * @description: MesWarehouseChgapply表类型
 */
export interface MesWarehouseChgapplyModel {
  id: number;

  isSysNum: string;

  dataCode: string;

  dataName: string;

  dataDate: string;

  dataUnit: string;

  dataUser: string;

  dataPhone: string;

  inStorage: string;

  outStorage: string;

  dataFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesWarehouseChgapplyDetailList?: MesWarehouseChgapplyDetailModel;
}

/**
 * @description: MesWarehouseChgapplyDetail表类型
 */
export interface MesWarehouseChgapplyDetailModel {
  id: number;

  applyId: number;

  productNo: string;

  productName: string;

  productId: string;

  speModel: string;

  deType: string;

  unity: string;

  num: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesWarehouseChgapply分页返回值结构
 */
export type MesWarehouseChgapplyPageResult = BasicFetchResult<MesWarehouseChgapplyPageModel>;
