
import { RokeStockLocationPageModel, RokeStockLocationPageParams, RokeStockLocationPageResult } from './model/CkwzModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/ckwz/page',
  List = '/jcsj/ckwz/list',
  Info = '/jcsj/ckwz/info',
  RokeStockLocation = '/jcsj/ckwz',
  
  
  
}

/**
 * @description: 查询RokeStockLocation分页列表
 */
export async function getRokeStockLocationPage(params: RokeStockLocationPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeStockLocationPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeStockLocation信息
 */
export async function getRokeStockLocation(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeStockLocationPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeStockLocation
 */
export async function addRokeStockLocation(rokeStockLocation: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeStockLocation,
      params: rokeStockLocation,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeStockLocation
 */
export async function updateRokeStockLocation(rokeStockLocation: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeStockLocation,
      params: rokeStockLocation,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeStockLocation（批量删除）
 */
export async function deleteRokeStockLocation(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeStockLocation,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




