import { Tag } from 'ant-design-vue';
import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { h } from 'vue';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '',
    component: 'Input',
    componentProps: { placeholder: '请输入关键字' },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
  {
    resizable: true,
    dataIndex: 'category',
    title: '分类',
    componentType: 'select',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
  {
    resizable: true,
    dataIndex: 'state',
    title: '启用禁用',
    componentType: 'switch',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'isDraft',
    title: '状态',
    componentType: 'input',
    customRender: ({ record }) => {
      const color = record.isDraft === 0 ? 'yellow' : 'blue';
      const text = record.isDraft === 0 ? '草稿' : '正常';
      return h(Tag, { color: color }, text);
    },
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 24, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '456c1313afcf492195964b4b7ff3492a',
      field: 'name',
      label: '页面名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入页面名称',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        bordered: true,
        isShowAi: true,
        style: { width: '100%' },
      },
    },
    {
      key: '08d17156892d4592bf7b71af34d4c07a',
      field: 'code',
      label: '页面编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入页面编码',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        bordered: true,
        isShowAi: true,
        style: { width: '100%' },
      },
    },
    {
      key: '853102e8f1734d4da89be54217a63c3b',
      field: 'category',
      label: '页面分类',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择页面分类',
        showLabel: true,
        showSearch: false,
        isMultiple: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        datasourceType: 'dic',
        params: { itemId: '1911711937169440769' },
        labelField: 'name',
        valueField: 'value',
        apiConfig: {
          path: 'CodeGeneration/selection',
          method: 'GET',
          apiId: '93d735dcb7364a0f8102188ec4d77ac7',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        isShow: true,
        itemId: '1911711937169440769',
        style: { width: '100%' },
      },
    },
    {
      key: '24d2ce36643343529d5239a52fcb74d9',
      field: 'state',
      label: '状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 12 },
      defaultValue: 1,
      componentProps: {
        span: '',
        defaultValue: 1,
        checkedChildren: '',
        unCheckedChildren: '',
        checkedColor: '#1C8DFF',
        unCheckedColor: '#bbbdbf',
        showLabel: true,
        disabled: false,
        events: {},
        isShow: true,
        style: {},
      },
    },
    {
      key: '072fe1b1e61c4b8cb25fa1ed14f5da59',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

//左侧树结构配置
export const treeConfig = {
  id: '',
  isMultiple: false,
  name: '',
  type: 1,
  configTip: '',
  config: [],
};
