import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProGroup分页参数 模型
 */
export interface MesProGroupPageParams extends BasicPageParams {
  groupNo: string;

  groupName: string;

  state: string;

  carId: string;

  remark: string;
}

/**
 * @description: MesProGroup分页返回值模型
 */
export interface MesProGroupPageModel {
  id: string;

  groupNo: string;

  groupName: string;

  leaderUser: string;

  userCount: string;

  carId: string;

  lineId: string;

  state: string;

  createUserId: string;

  createDate: string;

  remark: string;
}

/**
 * @description: MesProGroup表类型
 */
export interface MesProGroupModel {
  id: number;

  isSysNum: string;

  groupNo: string;

  groupName: string;

  factoryId: string;

  carId: string;

  lineId: string;

  leaderUser: string;

  userCount: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesProGroupuserList?: MesProGroupuserModel;
}

/**
 * @description: MesProGroupuser表类型
 */
export interface MesProGroupuserModel {
  id: number;

  groupId: string;

  userId: string;

  userName: string;

  userDept: string;

  userPhone: string;

  leaderFlag: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProGroup分页返回值结构
 */
export type MesProGroupPageResult = BasicFetchResult<MesProGroupPageModel>;
