import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  InspectPageListSearchModel,
  InspectAddParamsModel,
  InspectUpdateParamsModel,
  InspectPageListResultModel,
  InspectInfoModel,
} from './model';

enum Api {
  Page = '/caseErpDevice/caseErpDeviceInspect/page',
  Inspect = '/caseErpDevice/caseErpDeviceInspect',
  Info = '/caseErpDevice/caseErpDeviceInspect/info',
  Export = '/caseErpDevice/caseErpDeviceInspect/export',
}

/**
 * @description: 查询设备巡检（分页）
 */
export async function getDeviceInspectPageList(
  params?: InspectPageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<InspectPageListResultModel>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增设备巡检
 */
export async function addDeviceInspect(
  type: InspectAddParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<number>(
    {
      url: Api.Inspect,
      params: type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改设备巡检
 */
export async function updateDeviceInspect(
  params: InspectUpdateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.Inspect,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除设备巡检
 */
export async function deleteDeviceInspect(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Inspect,
      data: id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询设备巡检详情
 */
export async function getDeviceInspectInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<InspectInfoModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'POST',
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
