import { computed, onMounted, ref } from 'vue';
import { storeToRefs } from 'pinia';
import { useRuleProcessStore } from '../store';
import { NodeNameByType } from '../config';
import { Edge, useVueFlow } from '@vue-flow/core';
export default function () {
  const store = useRuleProcessStore();
  const { infoId } = store;
  const { info } = storeToRefs(store);
  const showPanel = ref(false);
  const formInfo = ref();

  const { updateNode } = useVueFlow();
  function updateElementName() {
    updateNode(formInfo.value.id, { data: { ...formInfo.value, label: formInfo.value.label } });
  }
  onMounted(() => {
    if (infoId) {
      formInfo.value = info.value.get(infoId);
      showPanel.value = true;
    }
  });
  const nodeName = computed(() => {
    if (formInfo.value && formInfo.value.type) {
      const labelName = NodeNameByType.has(formInfo.value.type)
        ? NodeNameByType.get(formInfo.value.type)
        : '节点';
      return labelName;
    }
    return '节点';
  });
  function getNextEdges() {
    const { toObject } = useVueFlow();
    let edgesArr: Edge[] = [];
    const demoVal = toObject();
    if (demoVal.edges && demoVal.edges.length > 0) {
      edgesArr = demoVal.edges.filter((ele) => {
        ele.label = ele.data.label;
        return ele.target == infoId;
      });
    }

    return edgesArr;
  }
  return {
    formInfo,
    nodeName,
    showPanel,
    updateElementName,
    getNextEdges,
  };
}
