import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'mc',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'mc',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'sjlx',
    title: '数据类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'bzz',
    title: '标准值',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'bzsx',
    title: '标准上限',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'bzxx',
    title: '标准下限',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '94121f06f0904837b085d05002995336',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: '6dc1d635739a4659ba45935e3fcb1977',
              field: 'bh',
              label: '编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: false,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '94675ea0ccc842aaaeec56e898af23ec',
              field: 'mc',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '6bcc83ede1a446bd95291c6af00ab4af',
              field: 'bzz',
              label: '标准值',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'd1f5113e7e8a462d8b33908230ea7fc3',
              field: 'bzsx',
              label: '标准上限',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                min: 0,
              //  max: ,
                step: 0.01,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '781dbbcd076e4d3c87e7f1bef5a237d7',
              field: 'bt',
              label: '必填项',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#c71a1a',
                unCheckedColor: '#6b6b6b',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: 'a70a1e8f07f342a5b92de0a9e8bb1777',
              field: 'sjlx',
              label: '数据类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2004076331787718658' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2004076331787718658',
                style: { width: '100%' },
              },
            },
            {
              key: '076321d9eb244b1c9f6e2f9ddc53091e',
              field: 'bzxx',
              label: '标准下限',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                min: 0,
                //max: ,
                step: 0.01,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '92d1871ca0d64b69ac370008fcd3be33',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '10c07ccba25c477ca06edef9d0965c8d',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 3,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
