import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'bommc',
    label: '物料名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'cpid',
    label: '选择产品',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/scgl/scjh/getAllProduct',
        method: 'GET',
        apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
        outputParams: [
          {
            name: 'cpbh',
            tableTitle: '产品编号',
            bindField: 'cpbh',
            show: true,
            width: 150,
            component: 'b2682f1ff2dc48448211cacb4bf48bfd',
          },
          {
            name: 'cpmc',
            tableTitle: '产品名称',
            bindField: 'cpmc',
            show: true,
            width: 150,
            component: 'db0bea5c2dbf4505833e67179e8618f3',
          },
          {
            name: 'gg',
            tableTitle: '产品规格',
            bindField: 'cpgg',
            show: true,
            width: 150,
            component: '3e7491b6d43c4ef7a7b6c2fd49a94a7f',
          },
          {
            name: 'xh',
            tableTitle: '产品型号',
            bindField: 'cpxh',
            show: true,
            width: 150,
            component: 'cf7d04d1e6374a3fbc4a9dfb9ebdf19e',
          },
        ],
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'sfyy',
    label: '是否有效',
    defaultValue: 1,
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'bommc',
    title: '物料名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'bomsl',
    title: '物料数量',
    componentType: 'number',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'bombb',
    title: '物料版本',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpmc',
    title: '产品名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpgg',
    title: '产品规格',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpxh',
    title: '产品型号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 2, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '4752659a82714a54967a2da899d68d24',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: '0bb6edfef8ac486482e02a6e650306e6',
              field: 'bommc',
              label: '物料名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入物料名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '4bc74304a0144e879b2fc45ae28ab1c5',
              field: 'bomsl',
              label: '物料数量',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                min: 0,
                step: 1,
                disabled: false,
                showLabel: true,
                controls: true,
                required: true,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                defaultValue: 0,
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '50bff2d4c82d40a98ace5fd2b1d3b41e',
              field: 'bombb',
              label: '物料版本',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入物料版本',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'c42ef62f38e1445b89e5c3362ffd3af2',
              field: 'cpid',
              label: '选择产品',
              type: 'associate-popup',
              component: 'MultiplePopup',
              colProps: { span: 24 },
              componentProps: {
                popupType: 'associate',
                width: '100%',
                span: 7,
                placeholder: '请选择产品选择',
                showLabel: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                pageSize: 10,
                assoTitle: '产品列表',
                apiConfig: {
                  path: '/scgl/scjh/getAllProduct',
                  method: 'GET',
                  apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                  outputParams: [
                    {
                      name: 'cpbh',
                      tableTitle: '产品编号',
                      bindField: 'cpbh',
                      show: true,
                      width: 150,
                      component: 'b2682f1ff2dc48448211cacb4bf48bfd',
                    },
                    {
                      name: 'cpmc',
                      tableTitle: '产品名称',
                      bindField: 'cpmc',
                      show: true,
                      width: 150,
                      component: 'db0bea5c2dbf4505833e67179e8618f3',
                    },
                    {
                      name: 'gg',
                      tableTitle: '产品规格',
                      bindField: 'cpgg',
                      show: true,
                      width: 150,
                      component: '3e7491b6d43c4ef7a7b6c2fd49a94a7f',
                    },
                    {
                      name: 'xh',
                      tableTitle: '产品型号',
                      bindField: 'cpxh',
                      show: true,
                      width: 150,
                      component: 'cf7d04d1e6374a3fbc4a9dfb9ebdf19e',
                    },
                  ],
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'b2682f1ff2dc48448211cacb4bf48bfd',
              field: 'cpbh',
              label: '产品编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入产品编号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'db0bea5c2dbf4505833e67179e8618f3',
              field: 'cpmc',
              label: '产品名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入产品名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: '3e7491b6d43c4ef7a7b6c2fd49a94a7f',
              field: 'cpgg',
              label: '产品规格',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入产品规格',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'cf7d04d1e6374a3fbc4a9dfb9ebdf19e',
              field: 'cpxh',
              label: '产品型号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入产品型号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'd8387e383f7342f8b829cb672dad42cb',
              field: 'sfyy',
              label: '是否有效',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                span: 7,
                defaultValue: 1,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                type: 1,
                event: [],
                style: {},
              },
            },
          ],
        },
        {
          span: 24,
          list: [
            {
              key: 'ccb91eb8f48b4ff3aaa1086f0adcd48e',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 2,
                defaultValue: '',
                placeholder: '请输入备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'c87fc2d18e24429a819521f35f19137b',
      label: '物料项',
      field: 'mesBaseBomItemList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesBaseBomItemList',
        columns: [
          {
            key: '709b38c05d11468db0db4e6e9168e4f9',
            title: '选择物料',
            dataIndex: 'wlmc',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              width: '100%',
              placeholder: '请选择物料选择',
              showLabel: true,
              disabled: false,
              datasourceType: 'api',
              labelField: 'label',
              valueField: 'value',
              pageSize: 10,
              assoTitle: '物料列表',
              apiConfig: {
                path: '/scgl/scjh/getAllProduct',
                method: 'GET',
                apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                apiParams: [
                  { key: '1', title: 'Query Params', tableInfo: [] },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                outputParams: [
                  {
                    name: 'cpbh',
                    tableTitle: '物料编号',
                    bindField: 'wlbh',
                    show: true,
                    width: 150,
                    component: '3988d1cba45a464abbeabce6ed09970e',
                    bindTable: 'mes_base_bom_item',
                  },
                  {
                    name: 'cpmc',
                    tableTitle: '物料名称',
                    bindField: 'wlmc',
                    show: true,
                    width: 150,
                    component: '112f6292bd884006ad872f06aeef4e6f',
                    bindTable: 'mes_base_bom_item',
                  },
                ],
              },
              dicOptions: [],
              required: true,
              rules: [],
              events: {},
              isShow: true,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: 'name',
            },
          },
          {
            key: '3988d1cba45a464abbeabce6ed09970e',
            title: '物料编号',
            dataIndex: 'wlbh',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              defaultValue: '',
              placeholder: '请输入物料编号',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: '112f6292bd884006ad872f06aeef4e6f',
            title: '物料名称',
            dataIndex: 'wuLiaoMingChen9398',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              defaultValue: '',
              placeholder: '请输入物料名称',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: true,
              isShow: false,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: '80fe637a2eaa47a49e96f6e86f0efdda',
            title: '物料数量',
            dataIndex: 'wlsl',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              min: 0,
              step: 1,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              isShow: true,
              rules: [],
              events: {},
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
              defaultValue: 0,
              listStyle: "return 'width:100%'",
            },
          },
          {
            key: '1afa69530c154b6f904f1661e82ff9a3',
            title: '库存数量',
            dataIndex: 'wlkcl',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              min: 0,
              step: 1,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              isShow: false,
              rules: [],
              events: {},
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
              defaultValue: 0,
              listStyle: "return 'width:100%'",
            },
          },
          {
            key: 'd15b4777d2794944995aa2a085442a6e',
            title: '客户标准（%）',
            dataIndex: 'khbz',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              min: 0,
              max: 100,
              step: 1,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              isShow: true,
              rules: [],
              events: {},
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
              defaultValue: 0,
              listStyle: "return 'width:100%'",
            },
          },
          {
            key: '1ef860d823ff46c690334dc5eff5a6e4',
            title: '内控标准（%）',
            dataIndex: 'nkbz',
            componentType: 'InputNumber',
            defaultValue: 0,
            componentProps: {
              width: '100%',
              min: 0,
              max: 100,
              step: 1,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              isShow: true,
              rules: [],
              events: {},
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
              defaultValue: 0,
              listStyle: "return 'width:100%'",
            },
          },
          {
            key: '40a1e893e8ee496a96d7ed6dbe17e271',
            title: '是否投料',
            dataIndex: 'sftl',
            componentType: 'Switch',
            defaultValue: 1,
            componentProps: {
              span: '',
              defaultValue: 1,
              checkedChildren: '',
              unCheckedChildren: '',
              checkedColor: '#1C8DFF',
              unCheckedColor: '#bbbdbf',
              showLabel: true,
              disabled: false,
              events: {},
              isShow: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          {
            key: '9230b500d1024028af68ed4ac49bdbd3',
            title: '备注',
            dataIndex: 'bz',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入备注',
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              listStyle: '',
              isSave: false,
              isShow: true,
              scan: false,
              bordered: true,
              isShowAi: false,
              tooltipConfig: { visible: false, title: '提示文本' },
              prestrainField: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: 2,
        preloadType: 'dic',
        apiConfig: {
          path: '/scgl/wlqd/getAllBomItemList',
          method: 'GET',
          apiId: '1a6a0c6bab2a4aceaf761b0c2c8d17a0',
          apiParams: [
            { key: '1', title: 'Query Params', tableInfo: [] },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            "var sql = 'select *,id as value,wlmc as label from mes_base_bom_item where delete_mark=0';\r\nreturn db.select(sql)",
        },
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择物料',
        showLabel: true,
        showComponentBorder: true,
        showBorder: false,
        bordercolor: '#f0f0f0',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        showIndex: false,
        isShow: true,
        multipleHeads: [],
        buttonList: [],
        topButtonList: [],
        isExport: false,
        isImport: false,
        isDeleteSelected: false,
        isListView: false,
        viewList: [
          {
            key: '112f6292bd884006ad872f06aeef4e6f',
            label: '物料名称',
            field: 'wlmc',
            componentType: 'input',
            checked: true,
          },
          {
            key: '3988d1cba45a464abbeabce6ed09970e',
            label: '物料编号',
            field: 'wlbh',
            componentType: 'input',
            checked: true,
          },
          {
            key: '80fe637a2eaa47a49e96f6e86f0efdda',
            label: '物料数量',
            field: 'wlsl',
            componentType: 'number',
            checked: true,
          },
          {
            key: '1afa69530c154b6f904f1661e82ff9a3',
            label: '库存数量',
            field: 'wlkcl',
            componentType: 'number',
            checked: true,
          },
          {
            key: 'd15b4777d2794944995aa2a085442a6e',
            label: '客户标准（%）',
            field: 'khbz',
            componentType: 'number',
            checked: true,
          },
          {
            key: '1ef860d823ff46c690334dc5eff5a6e4',
            label: '内控标准（%）',
            field: 'nkbz',
            componentType: 'number',
            checked: true,
          },
          {
            key: '9230b500d1024028af68ed4ac49bdbd3',
            label: '备注',
            field: 'bz',
            componentType: 'input',
            checked: true,
          },
          {
            key: '40a1e893e8ee496a96d7ed6dbe17e271',
            label: '是否投料',
            field: 'sftl',
            componentType: 'switch',
            checked: false,
          },
          {
            key: '709b38c05d11468db0db4e6e9168e4f9',
            label: '选择物料',
            field: 'bomid',
            componentType: 'associate-popup',
            checked: false,
          },
        ],
        isShowAdd: true,
        isShowDelete: true,
        hasCheckedCol: false,
        events: {},
        showPagenation: true,
        rowResize: false,
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
  },
];
