import useApiRequest from '/@/hooks/event/useApiRequest';
export async function getPrintData(apiConfig) {
  const { changeApiOptions } = useApiRequest();
  const printData: {
    apiFields: Array<{ text: string; field: string }>;
    subTabulation: Array<{
      text: string;
      field: string;
      columns: Array<{ text: string; field: string }>;
    }>;
  } = {
    apiFields: [],
    subTabulation: [],
  };
  const res = await changeApiOptions(apiConfig);
  if (typeof res === 'object') {
    for (const [key, value] of Object.entries(res)) {
      if (value && Array.isArray(value)) {
        if (value.length > 0) {
          const columns: Array<{ text: string; field: string }> = [];
          for (const key2 of Object.keys(value[0])) {
            columns.push({ text: key2, field: key2 });
          }
          printData.subTabulation.push({
            text: key,
            field: key,
            columns: columns,
          });
        }
      } else {
        printData.apiFields.push({
          text: key,
          field: key,
        });
      }
    }
  } else if (Array.isArray(res)) {
    const columns: Array<{ text: string; field: string }> = [];
    for (const key2 of res) {
      columns.push({ text: key2, field: key2 });
    }
    printData.subTabulation.push({
      text: 'table',
      field: 'table',
      columns: columns,
    });
  }
  return {
    apiFields: printData.apiFields,
    subTabulation: printData.subTabulation,
    data: res,
  };
}
