import {
  PageDesignPageModel,
  PageDesignPageParams,
  PageDesignPageResult,
} from './model/PageDesignModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/system/pagedesign/page',
  List = '/system/pagedesign/list',
  Info = '/system/pagedesign/info',
  PageDesign = '/system/pagedesign',
  history = '/system/pagedesign/history',
  historyInfo = '/system/pagedesign/history-info',
  publish = '/system/pagedesign/release',
}
/**
 * @description: 发布菜单
 */
export async function addPageDesignMenu(pageDesign: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.publish,
      params: pageDesign,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询历史记录分页列表
 */
export async function getHistory(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.history,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 获取PageDesign历史详情
 */
export async function getHistoryInfo(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.historyInfo,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询PageDesign分页列表
 */
export async function getPageDesignPage(
  params: PageDesignPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<PageDesignPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取PageDesign信息
 */
export async function getPageDesign(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<PageDesignPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增PageDesign
 */
export async function addPageDesign(pageDesign: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.PageDesign,
      params: pageDesign,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新PageDesign
 */
export async function updatePageDesign(pageDesign: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.PageDesign,
      params: pageDesign,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除PageDesign（批量删除）
 */
export async function deletePageDesign(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.PageDesign,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
