
import { MesMoldTypePageModel, MesMoldTypePageParams, MesMoldTypePageResult } from './model/MgflModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mjgl/mgfl/page',
  List = '/mjgl/mgfl/list',
  Info = '/mjgl/mgfl/info',
  MesMoldType = '/mjgl/mgfl',
  
  
  
}

/**
 * @description: 查询MesMoldType分页列表
 */
export async function getMesMoldTypePage(params: MesMoldTypePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesMoldTypePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesMoldType信息
 */
export async function getMesMoldType(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesMoldTypePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesMoldType
 */
export async function addMesMoldType(mesMoldType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesMoldType,
      params: mesMoldType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesMoldType
 */
export async function updateMesMoldType(mesMoldType: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesMoldType,
      params: mesMoldType,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesMoldType（批量删除）
 */
export async function deleteMesMoldType(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesMoldType,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




