
import { RokeRoutingPageModel, RokeRoutingPageParams, RokeRoutingPageResult } from './model/GylxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/gylx/page',
  List = '/jcsj/gylx/list',
  Info = '/jcsj/gylx/info',
  RokeRouting = '/jcsj/gylx',
  
  
  
}

/**
 * @description: 查询RokeRouting分页列表
 */
export async function getRokeRoutingPage(params: RokeRoutingPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeRoutingPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取RokeRouting信息
 */
export async function getRokeRouting(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RokeRoutingPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增RokeRouting
 */
export async function addRokeRouting(rokeRouting: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.RokeRouting,
      params: rokeRouting,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新RokeRouting
 */
export async function updateRokeRouting(rokeRouting: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.RokeRouting,
      params: rokeRouting,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除RokeRouting（批量删除）
 */
export async function deleteRokeRouting(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.RokeRouting,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




