import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface AlarmPageListParams {
  typeId?: string; //设备类型id
  state?: string; //状态 1-已处理 2-待处理
  startTime?: string; //开始时间
  endTime?: string; //结束时间
}

export interface AlarmUpdateParamsModel {
  id: string; //id
  dealWay: string; //处理方法
  dealUserIds: string; //处理人
  filePath?: string; //上传附件
  state?: string; //状态
}

export interface AlarmInfoModel {
  dealWay: string; //处理方法
  dealUserIds: string; //处理人
  filePath?: string; //上传附件
  state?: string; //状态
  level?: string; //故障等级
  remark?: string; //故障描述
}

export interface AlarmCheckModel {
  dealWay?: string; //处理方法
  dealUserNames?: string; //处理人
  filePath?: string; //上传附件
  state?: string; //状态
  levelName?: string; //故障等级
  remark?: string; //故障描述
}

export interface AlarmListModel {
  id: string; //详情id
  number: string; //设备编号
  name: string; //设备名称
  typeName: string; //设备类型
  address: string; //设备位置
  model: string; //规格型号
  level: string; //故障等级
  remark: number; //故障描述
  principalNames: string; //负责人
  buyDate: string; //购买日期
  maintianDate: string; //维保日期0
  state: number; //状态 0-异常 1-正常
}

export type AlarmPageListSearchModel = BasicPageParams & AlarmPageListParams;
export type AlarmPageListResultModel = BasicFetchResult<AlarmListModel>;
