import { FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '关键字',
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'code',
    title: '编码',
    componentType: 'input',

    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'category',
    title: '弹窗分类',
    componentType: 'select',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'state',
    title: '弹窗状态',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '正常', value: '1' },
        { key: 2, label: '停用', value: '0' },
      ];

      return staticOptions.filter((x) => x.value === record.state)[0]?.label;
    },

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
  {
    resizable: true,
    dataIndex: 'createUserName',
    title: '创建人',
    componentType: 'info',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
  {
    resizable: true,
    dataIndex: 'modifyUserName',
    title: '最后修改人',
    componentType: 'info',
    sorter: true,
    styleConfig: undefined,
    listStyle: undefined,
  },
  {
    resizable: true,
    dataIndex: 'modifyDate',
    title: '最后修改时间',
    componentType: 'info',
    sorter: true,
    styleConfig: undefined,
    listStyle: undefined,
  },
];
