import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesDev分页参数 模型
 */
export interface MesDevPageParams extends BasicPageParams {
  devCode: string;

  devName: string;

  factoryId: string;

  lineId: string;

  stationId: string;

  devBrand: string;

  devSupplier: string;

  devModel: string;

  buyDate: string;

  maintenanceDate: string;

  scrapDate: string;

  devManage: string;

  devPhone: string;

  remark: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesDev分页返回值模型
 */
export interface MesDevPageModel {
  id: string;

  devCode: string;

  devName: string;

  factoryId: string;

  lineId: string;

  stationId: string;

  devBrand: string;

  devSupplier: string;

  devModel: string;

  buyDate: string;

  maintenanceDate: string;

  scrapDate: string;

  devManage: string;

  devPhone: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesDev表类型
 */
export interface MesDevModel {
  id: number;

  factoryId: string;

  carId: string;

  lineId: string;

  stationId: string;

  devCode: string;

  devName: string;

  devBrand: string;

  devSupplier: string;

  devModel: string;

  buyDate: string;

  maintenanceDate: string;

  scrapDate: string;

  devPhone: string;

  devManage: string;

  remark: string;

  devFile: string;

  devFile2: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesDev分页返回值结构
 */
export type MesDevPageResult = BasicFetchResult<MesDevPageModel>;