import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'paramName',
    label: '参数名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'paramKey',
    label: '参数键',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'paramName',
    title: '参数名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'paramKey',
    title: '参数键',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'paramValue',
    title: '参数值',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'enabled',
    title: '是否启用',
    componentType: 'switch',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '004ba9a3722445029c015a530a772df2',
      field: 'paramName',
      label: '参数名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入参数名称',
        maxlength: 255,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        bordered: true,
        isShowAi: false,
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: '3a2f6cbd51e24374ba844ec73f75931d',
      field: 'paramKey',
      label: '参数键',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入参数键',
        maxlength: 255,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        listStyle: '',
        isSave: false,
        isShow: true,
        scan: false,
        bordered: true,
        isShowAi: false,
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: 'e155cd82ce524ffd9d2b92ef851c0492',
      field: 'paramValue',
      label: '参数值',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入参数值',
        maxlength: 2000,
        rows: 4,
        autoSize: false,
        showCount: true,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: '6f5b5a0fe94b407f898502948962fcee',
      field: 'description',
      label: '参数描述',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入参数描述',
        maxlength: 1000,
        rows: 4,
        autoSize: false,
        showCount: true,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        isShowAi: false,
        rules: [],
        events: {},
        tooltipConfig: { visible: false, title: '提示文本' },
        style: { width: '100%' },
      },
    },
    {
      key: '09fac2af15cc47f28ed269143e877f18',
      field: 'enabled',
      label: '是否启用',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        span: '',
        defaultValue: 1,
        checkedChildren: '',
        unCheckedChildren: '',
        checkedColor: '#1C8DFF',
        unCheckedColor: '#bbbdbf',
        showLabel: true,
        disabled: false,
        events: {},
        isShow: true,
        tooltipConfig: { visible: false, title: '提示文本' },
        style: {},
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
