import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'processCode',
    label: '工艺编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'processName',
    label: '工艺路线名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialId',
    label: '产品绑定',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getMaterialList',
        method: 'GET',
        apiId: '87c017a4baba48909380e9ca3e38359d',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'keyword',
                value: null,
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'showLabel',
                value: 'name',
                description: '回显字段：code/name',
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: 'name',
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,u.name as unit_name,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_unit u ON u.id=t.unit_id "\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,u.name as unit_name,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_unit u ON u.id=t.unit_id "\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
        outputParams: [
          { name: 'code', tableTitle: '物料编码', bindField: '', show: true, width: 150 },
          { name: 'name', tableTitle: '物料名称', bindField: '', show: true, width: 150 },
          { name: 'property_name', tableTitle: '物料属性', bindField: '', show: true, width: 150 },
          { name: 'type_name', tableTitle: '物料类别', bindField: '', show: true, width: 150 },
        ],
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'processCode',
    title: '工艺编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'processName',
    title: '工艺路线名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'materialId',
    title: '产品绑定',
    componentType: 'associate-popup',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: '120px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'eba0b99adc7e4b98b77dc639805f8db2',
      field: 'processCode',
      label: '工艺编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 20 },
      componentProps: {
        col: 20,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '工艺编码请输入工艺编码',
        addonBefore: '',
        autoCodeRule: 'mesProcessTechNo',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '4729e07174c642c4a9913621c6fc4960',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      componentProps: {
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '使用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "//是否使用系统编号事件：\nconst code='processCode';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: '9724877ea23c4f889412846c2ea448b1',
      field: 'processName',
      label: '工艺路线名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入工艺路线名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '2c8acc679b884ec69704bdcab70bcc00',
      field: 'materialId',
      label: '产品绑定',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 24 },
      componentProps: {
        popupType: 'associate',
        width: '100%',
        span: '',
        placeholder: '请选择产品绑定',
        showLabel: true,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getMaterialList',
          method: 'GET',
          apiId: '87c017a4baba48909380e9ca3e38359d',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: 'name',
                  description: '回显字段：code/name',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'name',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,u.name as unit_name,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_unit u ON u.id=t.unit_id "\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,u.name as unit_name,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_unit u ON u.id=t.unit_id "\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
          outputParams: [
            { name: 'code', tableTitle: '物料编码', bindField: '', show: true, width: 150 },
            { name: 'name', tableTitle: '物料名称', bindField: '', show: true, width: 150 },
            {
              name: 'property_name',
              tableTitle: '物料属性',
              bindField: '',
              show: true,
              width: 150,
            },
            { name: 'type_name', tableTitle: '物料类别', bindField: '', show: true, width: 150 },
          ],
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '3e7c7ad5c6484539a2d741d505e61030',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '54a9e6aa80df41b6b30d9d84adea1d36',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '93ad69c9b6c7467b9ce2330180c885f8',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '89243b5eea9d45fab2bb816806900d15',
      label: '',
      field: 'mesProcessTechnologyStepList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProcessTechnologyStepList',
        columns: [
          {
            key: 'aa55070c8cdf4fc380274e536f25ffa0',
            title: '工序id',
            dataIndex: 'processId',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入工序id单行文本',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'de7c1ea2aa464fb093d0fdb3e7df4f54',
            title: '工序名称',
            dataIndex: 'processName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入工序名称单行文本',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'd242fd300eec408dbb8ee7299cbd3041',
            title: '前置条件',
            dataIndex: 'preCondition',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入单行文本前置条件',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '6384df41a0284c268fcf959fc03f0a96',
            title: '静置it傲娇',
            dataIndex: 'staCondition',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入静置it傲娇单行文本',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
