import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '存储类型编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'name',
    label: '存储类型名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '类型状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'code',
    title: '存储类型编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'name',
    title: '存储类型名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '类型状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelCol: { offset: 0, span: 4 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '33c282000fdc46b99311c043aa34c6e5',
      field: 'code',
      label: '存储类型编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: 100,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '61f5f528bbcf4e10b0de9219ce9f9cd2',
      field: 'name',
      label: '存储类型名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: 100,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1c7450133c2642ee866d4c24e5b670c1',
      field: 'sort',
      label: '类型排序',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ba32ca361d304cefb1390d91f4cf1084',
      field: 'state',
      label: '类型状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'a5c13e47187a4719868779c034e733de',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: 200,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    // {
    //   key: '0fe0692915ee4e83b0a5e850fb728279',
    //   field: 'createUserId',
    //   label: '创建人',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 0,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
    // {
    //   key: '38db13cf017b4a0b9ad70e11c962c52c',
    //   field: 'createDate',
    //   label: '创建时间',
    //   type: 'info',
    //   component: 'Info',
    //   colProps: { span: 24 },
    //   componentProps: {
    //     showLabel: true,
    //     infoType: 2,
    //     width: '100%',
    //     disabled: true,
    //     placeholder: '',
    //     loadAgain: false,
    //     span: '',
    //     style: { width: '100%' },
    //   },
    // },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
