import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '编码',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'locationType',
    label: '位置类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2008349355210772481' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'stockLocationId',
    label: '仓库位置',
    defaultValue: undefined,
    component: 'TreeSelectComponent',
    componentProps: {
      span: 5,
      defaultValue: '',
      showLabel: true,
      isShow: true,
      required: true,
      events: {},
      rules: [],
      treeConfig: {
        id: '2008372971650543617',
        isMultiple: false,
        height: 100,
        innerParams: [],
        type: 2,
        isSaveLast: true,
      },
      tooltipConfig: { visible: false, title: '提示文本' },
      style: {},
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'code',
    title: '编码',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'locationType',
    title: '位置类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'stockLocationId',
    title: '仓库位置',
    componentType: 'tree-select-component',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'left',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '1884306810c14918936149fdc66077ac',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: '0c4bdf553f8143eaaa3bd0edb8db558e',
              field: 'code',
              label: '编码',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 5,
                placeholder: '自动生成',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'KWBM',
                required: true,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '600e8520e9734e51b44b6fcd93353494',
              field: 'locationType',
              label: '位置类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 5,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: '内部位置', value: '出库内部位置' },
                  { key: 2, label: '虚拟位置', value: '虚拟位置' },
                  { key: 3, label: '内部调拨客户位置', value: '内部调拨' },
                  { key: 4, label: '供应商位置', value: '供应商位置' },
                  { key: 5, label: '生产位置', value: '生产位置' },
                  { key: 6, label: '中转位置', value: '中转位置' },
                ],
                datasourceType: 'dic',
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                params: { itemId: '2008349355210772481' },
                itemId: '2008349355210772481',
                style: { width: '100%' },
              },
            },
            {
              key: '2dff5242b2f24782b4573ab20754d743',
              field: 'isMinus',
              label: '允许负库存',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: 'fe610f88625f4064a107013880539c7e',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 5,
                defaultValue: '',
                placeholder: '请输入名称',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {
                  change:
                    "\nformActionType.httpRequest({\n  requestType: 'get',\n  requestUrl: '/magic-api/getLocation', // \n  params: {\n    id: formModel.parent_id\n  },\n  errorMessageMode: 'none'\n}).then(res => {\n  if (res.length > 0) { \n    var parentName = res[0].name;\n    formModel.complete_name = parentName + '/' + formModel.name;\n  } else {\n    formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n\n  }\n}).catch(err => {\n  console.error('接口请求异常：', err);\n  formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n});",
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '9e1c5a7dc48c4a019479ed0957781e21',
              field: 'stockLocationId',
              label: '仓库位置',
              type: 'tree-select-component',
              component: 'TreeSelectComponent',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 5,
                defaultValue: '',
                showLabel: true,
                isShow: true,
                required: true,
                events: {},
                rules: [],
                treeConfig: {
                  id: '2008372971650543617',
                  isMultiple: false,
                  height: 100,
                  innerParams: [],
                  type: 2,
                  isSaveLast: true,
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '3d596686d6d549228f106658997e438e',
              field: 'isShowLocation',
              label: 'App是否需要扫货位\t',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 8,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'b202746eef0246968aa54d0370573e06',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 24,
          list: [
            {
              key: '28c29afe92d74f56bd1ccec18431a564',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 2,
                defaultValue: '',
                placeholder: '请输入备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
  },
];
