import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '名称',
    defaultValue: undefined,
    component: 'Input',
  },
  // {
  //   field: 'parentId',
  //   label: '上级位置',
  //   defaultValue: undefined,
  //   component: 'TreeSelectComponent',
  //   componentProps: {
  //     span: 5,
  //     defaultValue: '',
  //     showLabel: true,
  //     isShow: true,
  //     required: true,
  //     events: {},
  //     rules: [],
  //     treeConfig: {
  //       id: '2008372971650543617',
  //       isMultiple: false,
  //       height: 100,
  //       innerParams: [],
  //       type: 2,
  //       isSaveLast: true,
  //     },
  //     tooltipConfig: { visible: false, title: '提示文本' },
  //     style: {},
  //   },
  // },
  {
    field: 'locationType',
    label: '位置类型',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2008349355210772481' },
      labelField: 'name',
      valueField: 'value',
      mode: 'default',
      showSearch: true,
      getPopupContainer: () => document.body,
    }
  },
/*  {
    field: 'note',
    label: '备注',
    defaultValue: undefined,
    component: 'Input',
  },*/
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'name',
    title: '名称',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'parentId',
    title: '上级位置',
    componentType: 'tree-select-component',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
    customRender: ({ record }) => {
      return record.parentName || record.parentId || '';
    },
  },

  {
    resizable: true,
    dataIndex: 'locationType',
    title: '位置类型',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
  //
  // {
  //   resizable: true,
  //   dataIndex: 'completeName',
  //   title: '显示名称',
  //   componentType: 'input',
  //
  //   fixed: false,
  //   sorter: true,
  //
  //   styleConfig: undefined,
  //   listStyle: '',
  // },

  {
    resizable: true,
    dataIndex: 'note',
    title: '备注',
    componentType: 'textarea',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '1884306810c14918936149fdc66077ac',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: 'fe610f88625f4064a107013880539c7e',
              field: 'name',
              label: '名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: true,
                rules: [],
                events: {
                  change:
                    "\nformActionType.httpRequest({\n  requestType: 'get',\n  requestUrl: '/magic-api/getLocation', // \n  params: {\n    id: formModel.parent_id\n  },\n  errorMessageMode: 'none'\n}).then(res => {\n  if (res.length > 0) { \n    var parentName = res[0].name;\n    formModel.complete_name = parentName + '/' + formModel.name;\n  } else {\n    formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n\n  }\n}).catch(err => {\n  console.error('接口请求异常：', err);\n  formModel.complete_name = formModel.parent_id + '/' + formModel.name;\n});",
                },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '73701987bc4a471eaf01ba7f3263f94b',
              field: 'parentId',
              label: '上级位置',
              type: 'select',
              component: 'TreeSelectComponent',
              colProps: { span: 24 },
              componentProps: {
                span: 5,
                defaultValue: '',
                showLabel: true,
                isShow: true,
                required: true,
                events: {},
                rules: [],
                treeConfig: {
                  id: '2008372971650543617',
                  isMultiple: false,
                  height: 100,
                  innerParams: [],
                  type: 2,
                  isSaveLast: true,
                },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '600e8520e9734e51b44b6fcd93353494',
              field: 'locationType',
              label: '位置类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,

                datasourceType: 'dic',
                params: { itemId: '2008349355210772481' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2008349355210772481',
                style: { width: '100%' },
              },
            },
            {
              key: '17f5f8c5cb6645eba0d7f61089fd3361',
              field: 'productionLocation',
              label: '线边库',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '8f2c7ed15ba34da98771cec8d9eb9978',
              field: 'completeName',
              label: '显示名称',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入显示显示名称',
                maxlength: null,
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: false,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '93b40fa2500a44deb54d3b08d9e73eda',
              field: 'isShowLocation',
              label: 'App是否需要扫货位\t',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: '28c29afe92d74f56bd1ccec18431a564',
              field: 'note',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入备注',
                maxlength: null,
                rows: 5,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '2dff5242b2f24782b4573ab20754d743',
              field: 'isMinus',
              label: '允许负库存',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                span: 7,
                defaultValue: 0,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#1C8DFF',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

export const formButtons = [
  {
    key: 'confirm',
    code: 'confirm',
    name: '确定',
    style: 'primary',
    event: [],
    isShow: true,
    index: 2,
    type: 1,
    modal: null,
  },
  {
    key: 'cancel',
    code: 'cancel',
    name: '取消',
    style: 'default',
    event: [],
    isShow: true,
    index: 1,
    type: 1,
    modal: null,
  },
  {
    key: 'reset',
    code: 'reset',
    name: '重置',
    style: 'default',
    event: [],
    isShow: true,
    index: 0,
    type: 1,
    modal: null,
  },
];
