import {
  defaultProperties,
  dashboardProperties,
  informationProperties,
  chartLineProperties,
  pieProperties,
  radarProperties,
  gaugeProperties,
  funnelProperties,
  chartBarProperties,
  myTaskProperties,
  todoListProperties,
  modulesProperties,
  buttonProperties,
  tableProperties,
  categoryStackProperties,
  TabsTableProperties,
  ImageProperties,
  MapProperties,
  bannerProperties,
  titleProperties,
  iframeProperties,
} from './properties';
import { DesktopComponent } from '/@/enums/desktop';
import {
  ChartBarInfo,
  DesktopInfoItem,
  MixLineBarInfo,
  PieItemInfo,
} from '/@/model/desktop/designer';

export const backgroundInfo = {
  type: DesktopComponent.BACKGROUND,
  isShow: false,
  image: '',
  repeat: 'no-repeat',
  size: 'cover',
};

// 默认属性
export const defaultInfo = {
  x: 0,
  y: 0,
  i: '0',
  w: 2,
  h: 2,
  minW: 2,
  minH: 2,
  maxW: 12,
  maxH: 2,
  type: DesktopComponent.DASHBOARD,
  config: {
    ...defaultProperties,
  },
};
export const iframeInfo = {
  x: 0,
  y: 0,
  i: '0',
  w: 12,
  h: 12,
  minW: 2,
  minH: 2,
  maxW: 12,
  //maxH: 12,
  type: DesktopComponent.MYIFRAME,
  config: {
    ...iframeProperties,
  },
};
export const titleInfo = {
  x: 0,
  y: 0,
  i: '0',
  w: 2,
  h: 2,
  minW: 1,
  minH: 0.5,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.TITLE,
  config: {
    ...titleProperties,
  },
};
//数据面板
export const dashboardInfo = {
  x: 0,
  y: 0,
  i: '0',
  w: 2,
  h: 3,
  minW: 2,
  minH: 3,
  maxW: 12,
  maxH: 4,
  type: DesktopComponent.DASHBOARD,
  config: {
    ...dashboardProperties,
  },
};

//信息列表
export const informationInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 4,
  minH: 6,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.INFORMATION,
  config: {
    ...informationProperties,
  },
};

//折线/柱状图
export const chartLineInfo: MixLineBarInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 6,
  minH: 8,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.CHARTLINE,
  config: chartLineProperties,
};

//饼图
export const pieInfo: PieItemInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 12,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.PIE,
  config: {
    ...pieProperties,
  },
};

//雷达图

export const radarInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.RADAR,
  config: {
    ...radarProperties,
  },
};

//仪表盘

export const gaugeInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.GAUGE,
  config: {
    ...gaugeProperties,
  },
};

//漏斗图

export const funnelInfo = {
  x: 0,
  y: 0,
  w: 8,
  h: 10,
  i: '0',
  minW: 6,
  minH: 6,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.FUNNEL,
  config: {
    ...funnelProperties,
  },
};

//柱状百分比

export const chartBarInfo: ChartBarInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.CHARTBAR,
  config: {
    ...chartBarProperties,
  },
};
//我的任务

export const myTaskInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 4,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.MYTASK,
  config: {
    ...myTaskProperties,
  },
};

//待办事项

export const todoListInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 4,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.TODOLIST,
  config: {
    ...todoListProperties,
  },
};

//常用功能

export const modulesInfo = {
  x: 0,
  y: 0,
  w: 12,
  h: 4,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.MODULES,
  config: {
    ...modulesProperties,
  },
};
export const buttonInfo = {
  x: 0,
  y: 0,
  w: 12,
  h: 1.5,
  i: '0',
  minW: 1.5,
  minH: 1.5,
  maxW: 12,
  maxH: 1.5,
  type: DesktopComponent.BUTTON,
  config: {
    ...buttonProperties,
  },
};
export const tableInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 6,
  minH: 8,
  maxW: 12,
  maxH: Infinity,
  type: DesktopComponent.TABLE,
  config: {
    ...tableProperties,
  },
};
export const tabsTableInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 6,
  minH: 8,
  maxW: 12,
  maxH: Infinity,
  type: DesktopComponent.TABSTABLE,
  config: {
    ...TabsTableProperties,
  },
};
// 甘特图
export const categoryStackInfo = {
  x: 0,
  y: 0,
  w: 6,
  h: 10,
  i: '0',
  minW: 4,
  minH: 4,
  maxW: 12,
  maxH: 12,
  type: DesktopComponent.CATEGORY_STACK,
  config: {
    ...categoryStackProperties,
  },
};
export const imageInfo = {
  x: 0,
  y: 0,
  w: 4,
  h: 4,
  i: '0',
  minW: 0,
  minH: 0,
  maxW: 12,
  maxH: Infinity,
  type: DesktopComponent.IMAGE,
  config: {
    ...ImageProperties,
  },
};
export const mapInfo = {
  x: 0,
  y: 0,
  w: 12,
  h: 12,
  i: '0',
  minW: 0,
  minH: 0,
  maxW: 12,
  maxH: Infinity,
  type: DesktopComponent.MAP,
  config: {
    ...MapProperties,
  },
};

//Banner图
export const bannerInfo = {
  i: '0',
  h: 4,
  w: 4,
  type: DesktopComponent.BANNER,
  config: {
    ...bannerProperties,
  },
};

// 获取组件属性
export const InfoByType: Map<DesktopComponent, DesktopInfoItem> = new Map([
  [DesktopComponent.DASHBOARD, dashboardInfo],
  [DesktopComponent.INFORMATION, informationInfo],
  [DesktopComponent.CHARTLINE, chartLineInfo],
  [DesktopComponent.PIE, pieInfo],
  [DesktopComponent.RADAR, radarInfo],
  [DesktopComponent.GAUGE, gaugeInfo],
  [DesktopComponent.FUNNEL, funnelInfo],
  [DesktopComponent.CATEGORY_STACK, categoryStackInfo],
  [DesktopComponent.CHARTBAR, chartBarInfo],
  [DesktopComponent.MYTASK, myTaskInfo],
  [DesktopComponent.TODOLIST, todoListInfo],
  [DesktopComponent.MODULES, modulesInfo],
  [DesktopComponent.BUTTON, buttonInfo],
  [DesktopComponent.TABLE, tableInfo],
  [DesktopComponent.TABSTABLE, tabsTableInfo],
  [DesktopComponent.IMAGE, imageInfo],
  [DesktopComponent.MAP, mapInfo],
  [DesktopComponent.BANNER, bannerInfo],
  [DesktopComponent.TITLE, titleInfo],
  [DesktopComponent.MYIFRAME, iframeInfo],
]);
